#!/usr/bin/python3

# ************************************************************
# Copyright © 2003-2025 Acronis International GmbH.
# This source code is distributed under MIT software license.
# ************************************************************

import asyncio
import sys
import logging
import argparse
from os.path import join, dirname, realpath

from connector import connector
from api_client import ApiClient
from utils import sqlite_connect
from constants import CLIENT_ID, CLIENT_SECRET, DC_URL


logging.basicConfig(format='[Connector] %(asctime)s -- %(message)s', encoding='utf-8', level=logging.INFO)

async def main(args):
    filename = join(dirname(realpath(__file__)), f'{args.db_name}.db')

    db = sqlite_connect(filename)
    async with ApiClient(DC_URL, CLIENT_ID, CLIENT_SECRET) as client:
        await connector(db, client)
    db.close()


if __name__ == '__main__':
    if sys.platform == 'win32':
        asyncio.set_event_loop_policy(asyncio.WindowsSelectorEventLoopPolicy())

    parser = argparse.ArgumentParser()
    parser.add_argument('--db-name',  help='Database name', default='vendor')

    args = parser.parse_args()

    asyncio.run(main(args))
