# ************************************************************
# Copyright © 2003-2025 Acronis International GmbH.
# This source code is distributed under MIT software license.
# ************************************************************

import sqlite3
from datatypes import *
from aiohttp import web
from constants import APPCODE

SECURITY_TOOL_GLOBAL_SETTINGS = {
    "notifyUser" : False,
    "defaultAction": "delete"
}

SECURITY_TOOL_GLOBAL_EXCLUSION_LIST: list = [
        {
            "exclusion_id" : 1,
            "enabled" : 1,
            "name" : "Windows System32",
            "path" : "c:\\windows\\system32"
        },
        {
            "exclusion_id" : 2,
            "enabled" : 0,
            "name": "Microsoft Program Files",
            "path" : "c:\\Program Files\\Microsoft\\*"
        }
    ]

def callback_read_global_exclusions(conn: sqlite3.Connection, organization_id: str | None, request_id: str, response_id: str, context: CallbackContext, payload: dict) -> web.Response:
    return web.json_response(
        status=200,
        data=CallbackResponse(
            type=f"cti.a.p.acgw.response.v1.0~{APPCODE}.read_global_exclusions_exclusions_read.v1.0",
            request_id=request_id,
            response_id=response_id,
            payload={ 'exclusions': SECURITY_TOOL_GLOBAL_EXCLUSION_LIST }
        )
    )

def callback_bulk_update_exclusions(conn: sqlite3.Connection, organization_id: str | None, request_id: str, response_id: str, context: CallbackContext, payload: dict) -> web.Response:
    global SECURITY_TOOL_GLOBAL_EXCLUSION_LIST
    SECURITY_TOOL_GLOBAL_EXCLUSION_LIST = payload['exclusions']

    return web.json_response(
        status=200,
        data=CallbackResponse(
            type=f"cti.a.p.acgw.response.v1.0~{APPCODE}.bulk_update_exclusions_success.v1.0",
            request_id=request_id,
            response_id=response_id
        )
    )

def callback_add_global_exclusion(conn: sqlite3.Connection, organization_id: str | None, request_id: str, response_id: str, context: CallbackContext, payload: dict) -> web.Response:
    global SECURITY_TOOL_GLOBAL_EXCLUSION_LIST
    if len(SECURITY_TOOL_GLOBAL_EXCLUSION_LIST) == 0:
        exclusion_id = 1
    else:
        exclusion_id = SECURITY_TOOL_GLOBAL_EXCLUSION_LIST[-1]['exclusion_id'] + 1
    exclusion = {
        "exclusion_id" : exclusion_id,
        "name" : payload['name'],
        "path" : payload['path'],
        "enabled": 1,
    }
    if 'enabled' in payload:
        exclusion['enabled'] = payload['enabled']
    SECURITY_TOOL_GLOBAL_EXCLUSION_LIST.append(exclusion)

    return web.json_response(
        status=200,
        data=CallbackResponse(
            type=f"cti.a.p.acgw.response.v1.0~{APPCODE}.add_global_exclusion_success.v1.0",
            request_id=request_id,
            response_id=response_id,
            payload={ 'exclusion_id': exclusion_id }
        )
    )

def callback_delete_exclusion(conn: sqlite3.Connection, organization_id: str | None, request_id: str, response_id: str, context: CallbackContext, payload: dict) -> web.Response:
    exclusion_id = payload['exclusion_id']
    global SECURITY_TOOL_GLOBAL_EXCLUSION_LIST
    SECURITY_TOOL_GLOBAL_EXCLUSION_LIST[:] = (value for value in SECURITY_TOOL_GLOBAL_EXCLUSION_LIST if value['exclusion_id'] != exclusion_id)

    return web.json_response(
        status=200,
        data=CallbackResponse(
            type=f"cti.a.p.acgw.response.v1.0~{APPCODE}.delete_exclusion_success.v1.0",
            request_id=request_id,
            response_id=response_id,
            payload={ 'exclusion_id': exclusion_id }
        )
    )

def callback_read_custom_settings(conn: sqlite3.Connection, organization_id: str | None, request_id: str, response_id: str, context: CallbackContext, payload: dict) -> web.Response:
    global SECURITY_TOOL_GLOBAL_SETTINGS

    return web.json_response(
        status=200,
        data=CallbackResponse(
            type=f"cti.a.p.acgw.response.v1.0~{APPCODE}.read_custom_settings_success.v1.0",
            request_id=request_id,
            response_id=response_id,
            payload={
                'defaultAction': SECURITY_TOOL_GLOBAL_SETTINGS['defaultAction'],
                'notifyUser': SECURITY_TOOL_GLOBAL_SETTINGS['notifyUser']
            }
        )
    )

def callback_update_custom_settings(conn: sqlite3.Connection, organization_id: str | None, request_id: str, response_id: str, context: CallbackContext, payload: dict) -> web.Response:
    global SECURITY_TOOL_GLOBAL_SETTINGS
    SECURITY_TOOL_GLOBAL_SETTINGS["defaultAction"] = payload["defaultAction"]
    SECURITY_TOOL_GLOBAL_SETTINGS["notifyUser"] = payload["notifyUser"]

    return web.json_response(
        status=200,
        data=CallbackResponse(
            type=f"cti.a.p.acgw.response.v1.0~{APPCODE}.update_custom_settings_success.v1.0",
            request_id=request_id,
            response_id=response_id
        )
    )

def callback_remediate_malware(conn: sqlite3.Connection, organization_id: str | None, request_id: str, response_id: str, context: CallbackContext, payload: dict) -> web.Response:
    return web.json_response(
        status=200,
        data=CallbackResponse(
            type=f"cti.a.p.acgw.response.v1.0~{APPCODE}.remediate_malware_success.v1.0",
            request_id=request_id,
            response_id=response_id
        )
    )

mapping = {
    f'cti.a.p.acgw.callback.v1.0~{APPCODE}.read_global_exclusions.v1.0': callback_read_global_exclusions,
    f'cti.a.p.acgw.callback.v1.0~{APPCODE}.bulk_update_exclusions.v1.0': callback_bulk_update_exclusions,
    f'cti.a.p.acgw.callback.v1.0~{APPCODE}.add_global_exclusion.v1.0': callback_add_global_exclusion,
    f'cti.a.p.acgw.callback.v1.0~{APPCODE}.delete_exclusion.v1.0': callback_delete_exclusion,
    f'cti.a.p.acgw.callback.v1.0~{APPCODE}.read_custom_settings.v1.0': callback_read_custom_settings,
    f'cti.a.p.acgw.callback.v1.0~{APPCODE}.update_custom_settings.v1.0': callback_update_custom_settings,
    f'cti.a.p.acgw.callback.v1.0~{APPCODE}.remediate_malware.v1.0': callback_remediate_malware,
}
