# ************************************************************
# Copyright © 2003-2025 Acronis International GmbH.
# This source code is distributed under MIT software license.
# ************************************************************

from aiohttp import web

import server.handlers as handlers

ROUTES = (
    web.RouteDef('GET',  '/',         handler=handlers.index,            kwargs={'name': 'index'}),
    web.RouteDef('GET',  '/ott',      handler=handlers.ott_login,        kwargs={'name': 'ott'}),

    # TODO: Hybrid with partner mapping and customer mirroring
    web.RouteDef('POST', '/mirroring/callback', handler=handlers.callback_handler_mirroring, kwargs={'name': 'callback_mirroring'}),
    web.RouteDef('POST', '/mapping/callback',   handler=handlers.callback_handler_mapping, kwargs={'name': 'callback_mapping'}),
)

def setup(app: web.Application):
    app.router.add_routes(ROUTES)
