# CyberApp packaging

Cyber Application introduces list of CTI entities extending Acronis Cyber Cloud, there instances are packed into the Cyber Application packages 

Each CTI entity is represented with RAML and stored on of the many raml files inside the package.

Cyber Application package package contains:

`index.json` - file contains overall information about application as well as registry of .raml files with localization
`**/*.raml` - files in raml format with list of CTI entities
`**/assets/` (optional) - directory in the root of the package, contains Application binary assets that can be used by CTI instances
`**/dictionary/` (optional)- directory with localized strings to be used by CTI instates, should be places at the same sub-directory with raml using that strings.

## Versioning

CTI: cti.<ctx_a>~<ctx_b>
CTX: <vendor>.<application>.<name>.v<major>.<minor>

| vendor      | application's vendor |
| application | application name |
| name        | entity name |
| major/minor | entity version |

## Requirements

1. application dependencies
1. backward compatibility
1. application coexistence
1. grant access to entities brought by exact application version

## Use-cases

1. Grant access to all instances brought by application `v11.22`

|  application     |  entity        |
| ---------------- | -------------- |
| x.y.v1.0         | ~x.y.RRR.v1.0  |
|                  |                |
| x.y.v20.0        | ~x.y.aaa.v1.0  |
|                  | ~x.y.bbb.v20.0 |
|                  | ~x.y.ccc.v3.0  |
|                  |                |
| x.y.v21.0        | ~x.y.aaa.v21.0 |
|                  | ~x.y.bbb.v20.0 |
|                  | ~x.y.ccc.v3.0  |

