# Platform SDK RAML

## CTI Registry

> **NOTE**: This section is generated automatically. Do not make any manual changes in it.


### Global Registry

|Name|Kind|Description|
|---|---|---|
|[cti.a.p.gr.record.v1.0](gr/types.raml#32-79)|Type|A Namespace is a logical unit for a group of key-value pairs.|
|[cti.a.p.gr.record.v1.0~a.p.app.statistics.v1.0](gr/integrations.raml#249-283)|Type|Contains statistic information of all enabled specified app versions collected by any app mgr|
|[cti.a.p.gr.record.v1.0~a.p.core.tenants.v1.0](gr/tenant.raml#10-23)|Type|Global Registry namespace, containing info about tenants on Production DCs. |
|[cti.a.p.gr.record.v1.0~a.p.integrations.app_types.v1.0](gr/integrations.raml#74-114)|Type|Global Registry namespace, containing data about application types. |
|[cti.a.p.gr.record.v1.0~a.p.integrations.applications.v1.0](gr/integrations.raml#8-21)|Type|Global Registry namespace, containing data about applications. |
|[cti.a.p.gr.record.v1.0~a.p.integrations.categories.v1.0](gr/integrations.raml#115-158)|Type|Global Registry namespace, containing data about categories. |
|[cti.a.p.gr.record.v1.0~a.p.integrations.datacenter.v2.0](gr/integrations.raml#50-73)|Type|Global Registry namespace, containing data about datacenters. |
|[cti.a.p.gr.record.v1.0~a.p.integrations.datacenters.v1.0](gr/integrations.raml#36-49)|Type|Global Registry namespace, containing data about datacenters. |
|[cti.a.p.gr.record.v1.0~a.p.integrations.launch_requests.v1.0](gr/integrations.raml#187-200)|Type|Global Registry namespace, containing data about launch requests. |
|[cti.a.p.gr.record.v1.0~a.p.integrations.launches.v1.0](gr/integrations.raml#173-186)|Type|Global Registry namespace, containing data about launches. |
|[cti.a.p.gr.record.v1.0~a.p.integrations.lr_errors.v1.0](gr/integrations.raml#215-234)|Type|Global Registry namespace, containing data about launch requests which cannot be processed. |
|[cti.a.p.gr.record.v1.0~a.p.integrations.lr_target_results.v1.0](gr/integrations.raml#201-214)|Type|Global Registry namespace, containing data about launch requests results. |
|[cti.a.p.gr.record.v1.0~a.p.integrations.manifests.v1.0](gr/integrations.raml#22-35)|Type|Global Registry namespace, containing data about manifests. |
|[cti.a.p.gr.record.v1.0~a.p.integrations.packages.v1.0](gr/integrations.raml#235-248)|Type|Global Registry namespace, containing data about packages. |
|[cti.a.p.gr.record.v1.0~a.p.integrations.regions.v1.0](gr/integrations.raml#159-172)|Type|Global Registry namespace, containing data about regions. |
|[cti.a.p.gr.record.v1.0~a.p.replication.managed_clients.v1.0](gr/replication.raml#10-23)|Type|Global Registry namespace, containing data about managed clients. |
|[cti.a.p.gr.record.v1.0~a.p.self_management.country_dc_map_abs.v1.0](gr/self_management.raml#22-67)|Type|Global Registry namespace, containing country codes matched to datacenters in 1-to-1 relationship based on availability for business (ABS) accounts. |
|[cti.a.p.gr.record.v1.0~a.p.self_management.root_tenants.v1.0](gr/self_management.raml#8-21)|Type|Global Registry namespace, containing data about root tenants. |
|[cti.a.p.gr.record.v1.0~a.p.smpc.servers_locations.v1.0](gr/smpc.raml#8-20)|Type|Global Registry namespace, containing data about server locations. |
|[cti.a.p.gr.record.v1.0~a.p.web_restore_shared_links.v1.0](gr/web_restore.raml#8-21)|Type|Global Registry namespace, containing data about Web Restore shared links. |
|[cti.a.p.gr.record.v1.0~a.p.web_restore_user_links.v1.0](gr/web_restore.raml#22-34)|Type|Global Registry namespace, containing data about Web Restore user links. |

### Event Management

|Name|Kind|Description|
|---|---|---|
|[cti.a.p.em.event.v1.0](em/types.raml#162-312)|Type|Defines the structure of the event that has occurred. Events will contain two types of information: the event data representing the occurrence and context metadata providing contextual information about the occurrence. A single occurrence may result in more than one event. Events are limited to a maximum size of 64KB, which includes both headers and payload. |
|[cti.a.p.em.event.v1.0~a.p.agent.re_registered.v1.0](em/agent.raml#40-49)|Type|An agent has re-registered. Agent's tenant and configurations of functional units the agent consists of remained the same, but unit metadata, agent's time zone and host network information were reset. Version and/or set of the units might also change during this event.|
|[cti.a.p.em.event.v1.0~a.p.agent.registered.v1.0](em/agent.raml#31-39)|Type|An agent has registered with Platform. The agent was not registered before the event occurred or it was registered with a different tenant.|
|[cti.a.p.em.event.v1.0~a.p.agent.unregistered.v1.0](em/agent.raml#50-59)|Type|An agent has been un-registered. All the information about given agent has been removed.|
|[cti.a.p.em.event.v1.0~a.p.am.alert.created.v1.0](em/alert.raml#27-34)|Type|Alert created event|
|[cti.a.p.em.event.v1.0~a.p.am.alert.dismissed.v1.0](em/alert.raml#43-50)|Type|Alert dismissed event|
|[cti.a.p.em.event.v1.0~a.p.am.alert.marked_false_positive.v1.0](em/alert.raml#51-58)|Type|Alert marked as false positive event|
|[cti.a.p.em.event.v1.0~a.p.am.alert.unmarked_false_positive.v1.0](em/alert.raml#59-65)|Type|Alert unmarked as false positive event|
|[cti.a.p.em.event.v1.0~a.p.am.alert.updated.v1.0](em/alert.raml#35-42)|Type|Alert updated event|
|[cti.a.p.em.event.v1.0~a.p.app.cti_entities.created.v1.0](em/cti_entities.raml#47-65)|Type|Event generated on new CTI entities were created (deployed).|
|[cti.a.p.em.event.v1.0~a.p.app.cti_entities.provisioning_changed.v1.0](em/cti_entities.raml#25-46)|Type|Event generated on provisioning state changed for one or multiple cti entities. If Cyber Application provisioning state changed, event with multiple entities produced. If anonymous entity provisioning state changed, event with single entity produced. |
|[cti.a.p.em.event.v1.0~a.p.app.cti_entities.updated.v1.0](em/cti_entities.raml#66-83)|Type|Event generated on existing CTI entities were updated.|
|[cti.a.p.em.event.v1.0~a.p.app.cyberapp.disabled.v1.0](em/cyberapps.raml#44-61)|Type|Event generated once a cyberapp has been disabled.|
|[cti.a.p.em.event.v1.0~a.p.app.cyberapp.enabled.v1.0](em/cyberapps.raml#24-43)|Type|Event generated once a cyberapp has been enabled. |
|[cti.a.p.em.event.v1.0~a.p.application.turned_off.v1.0](em/licensing.raml#58-68)|Type|Event is raised when application is turned off|
|[cti.a.p.em.event.v1.0~a.p.applications.turned_on.v1.0](em/licensing.raml#47-57)|Type|Event is raised when application is turned on|
|[cti.a.p.em.event.v1.0~a.p.audit.v1.0](em/audit.raml#41-51)|Type|Base type for audit events|
|[cti.a.p.em.event.v1.0~a.p.audit.v1.0~a.p.archive.deletion.triggered.v1.0](em/archive_audit.raml#20-33)|Type|Event is raised when deletion of an archive for a tenant is triggered in email archiving.|
|[cti.a.p.em.event.v1.0~a.p.audit.v1.0~a.p.archiving.plan.created.v1.0](em/archiving_plan_audit.raml#22-36)|Type|Archiving plan created.|
|[cti.a.p.em.event.v1.0~a.p.audit.v1.0~a.p.archiving.plan.deleted.v1.0](em/archiving_plan_audit.raml#52-65)|Type|Archiving plan deleted.|
|[cti.a.p.em.event.v1.0~a.p.audit.v1.0~a.p.archiving.plan.updated.v1.0](em/archiving_plan_audit.raml#37-51)|Type|Archiving plan updated.|
|[cti.a.p.em.event.v1.0~a.p.audit.v1.0~a.p.attachment.download.started.v1.0](em/email_audit.raml#49-62)|Type|Event is raised when download of email attachment of an m365 or gsuite organization is started.|
|[cti.a.p.em.event.v1.0~a.p.audit.v1.0~a.p.email.recovery.started.v1.0](em/email_audit.raml#33-48)|Type|Event is raised when recovery of an email for an m365 or gsuite organization is started.|
|[cti.a.p.em.event.v1.0~a.p.audit.v1.0~a.p.legalhold.created.v1.0](em/legal_hold_audit.raml#43-57)|Type|Legal hold created.|
|[cti.a.p.em.event.v1.0~a.p.audit.v1.0~a.p.legalhold.deleted.v1.0](em/legal_hold_audit.raml#73-87)|Type|Legal hold deleted.|
|[cti.a.p.em.event.v1.0~a.p.audit.v1.0~a.p.legalhold.disabled.v1.0](em/legal_hold_audit.raml#103-117)|Type|Legal hold disabled.|
|[cti.a.p.em.event.v1.0~a.p.audit.v1.0~a.p.legalhold.enabled.v1.0](em/legal_hold_audit.raml#88-102)|Type|Legal hold enabled.|
|[cti.a.p.em.event.v1.0~a.p.audit.v1.0~a.p.legalhold.executed.v1.0](em/legal_hold_audit.raml#118-131)|Type|Legal hold executed.|
|[cti.a.p.em.event.v1.0~a.p.audit.v1.0~a.p.legalhold.updated.v1.0](em/legal_hold_audit.raml#58-72)|Type|Legal hold updated.|
|[cti.a.p.em.event.v1.0~a.p.audit.v1.0~a.p.organization.registration.started.v1.0](em/organization_audit.raml#21-36)|Type|Event is raised when registration of an organization for a tenant is started in email archiving.|
|[cti.a.p.em.event.v1.0~a.p.audit.v1.0~a.p.organization.removal.started.v1.0](em/organization_audit.raml#37-50)|Type|Event is raised when removal of an organization for a tenant is started in email archiving.|
|[cti.a.p.em.event.v1.0~a.p.audit.v1.0~a.p.policy.created.v1.0](em/policy_audit.raml#41-56)|Type|Policy created. subjectId format - UUID.CREATED_AT where CreatedAt - timestamp UTC in nanoseconds - time.UTC().UnixNano()|
|[cti.a.p.em.event.v1.0~a.p.audit.v1.0~a.p.policy.deleted.v1.0](em/policy_audit.raml#57-72)|Type|Policy deleted. subjectId format - UUID.DELETED_AT where DeletedAt - timestamp UTC in nanoseconds - time.UTC().UnixNano()|
|[cti.a.p.em.event.v1.0~a.p.audit.v1.0~a.p.policy.updated.v1.0](em/policy_audit.raml#73-94)|Type|Policy updated. subjectId format - UUID.UPDATED_AT where UpdatedAt - timestamp UTC in nanoseconds - time.UTC().UnixNano()|
|[cti.a.p.em.event.v1.0~a.p.audit.v1.0~a.p.retention.rule.created.v1.0](em/retention_rule_audit.raml#44-58)|Type|Retention rule created.|
|[cti.a.p.em.event.v1.0~a.p.audit.v1.0~a.p.retention.rule.deleted.v1.0](em/retention_rule_audit.raml#74-88)|Type|Retention rule deleted.|
|[cti.a.p.em.event.v1.0~a.p.audit.v1.0~a.p.retention.rule.disabled.v1.0](em/retention_rule_audit.raml#104-118)|Type|Retention rule disabled.|
|[cti.a.p.em.event.v1.0~a.p.audit.v1.0~a.p.retention.rule.enabled.v1.0](em/retention_rule_audit.raml#89-103)|Type|Retention rule enabled.|
|[cti.a.p.em.event.v1.0~a.p.audit.v1.0~a.p.retention.rule.executed.v1.0](em/retention_rule_audit.raml#119-132)|Type|Retention rule executed.|
|[cti.a.p.em.event.v1.0~a.p.audit.v1.0~a.p.retention.rule.updated.v1.0](em/retention_rule_audit.raml#59-73)|Type|Retention rule updated.|
|[cti.a.p.em.event.v1.0~a.p.audit.v1.0~a.p.workload.created.v1.0](em/workload_audit.raml#34-48)|Type|Workload created. subjectId format - UUID.CREATED_AT where CreatedAt - timestamp UTC in nanoseconds - time.UTC().UnixNano()                                                                                                                                                                                                                                                                                                                                                                               |
|[cti.a.p.em.event.v1.0~a.p.audit.v1.0~a.p.workload.deleted.v1.0](em/workload_audit.raml#50-64)|Type|Workload deleted. subjectId format - UUID.DELETED_AT where DeletedAt - timestamp UTC in nanoseconds - time.UTC().UnixNano()                                                                                                                                                                                                                                                                                                                                                                                |
|[cti.a.p.em.event.v1.0~a.p.client.created.v1.0](em/client.raml#25-40)|Type|Event is raised on oauth client creation.|
|[cti.a.p.em.event.v1.0~a.p.client.deleted.v1.0](em/client.raml#73-87)|Type|Event is raised when oauth client is being deleted.|
|[cti.a.p.em.event.v1.0~a.p.client.secret_reset.v1.0](em/client.raml#57-72)|Type|Event is raised when oauth client's secret is being reset|
|[cti.a.p.em.event.v1.0~a.p.client.updated.v1.0](em/client.raml#41-56)|Type|Event is raised when oauth client is being updated.|
|[cti.a.p.em.event.v1.0~a.p.licensing.trigger.fired.v1.0](em/licensing.raml#112-123)|Type|Event is raised when licensing trigger is fired|
|[cti.a.p.em.event.v1.0~a.p.gr.record.created.v1.0](em/global_registry.raml#26-47)|Type|Sent when new key-value pair (or record) is created|
|[cti.a.p.em.event.v1.0~a.p.gr.record.deleted.v1.0](em/global_registry.raml#70-89)|Type|Sent when a key-value pair (or record) is deleted|
|[cti.a.p.em.event.v1.0~a.p.gr.record.updated.v1.0](em/global_registry.raml#48-69)|Type|Sent when existing key-value pair (or record) is updated|
|[cti.a.p.em.event.v1.0~a.p.offering_item.turned_off.v1.0](em/licensing.raml#69-79)|Type|Event is raised when an offering item is turned off|
|[cti.a.p.em.event.v1.0~a.p.offering_item.turned_on.v1.0](em/licensing.raml#80-90)|Type|Event is raised when an offering item is turned on|
|[cti.a.p.em.event.v1.0~a.p.policy.application.changed.v1.0](em/policy.raml#83-101)|Type|Event for policy application changed (revoked/applied) from a workload. subjectId format - UUID from policy ID modified (revoked/applied)|
|[cti.a.p.em.event.v1.0~a.p.policy.created.v1.0](em/policy.raml#23-42)|Type|Event for policy created. subjectId format - UUID from policy ID created|
|[cti.a.p.em.event.v1.0~a.p.policy.deleted.v1.0](em/policy.raml#43-62)|Type|Event for policy deleted. subjectId format - UUID from policy ID deleted|
|[cti.a.p.em.event.v1.0~a.p.policy.updated.v1.0](em/policy.raml#63-82)|Type|Event for policy updated. subjectId format - UUID from policy ID updated|
|[cti.a.p.em.event.v1.0~a.p.quota.available.v1.0](em/licensing.raml#110-119)|Type|Event is raised when the quota becomes available|
|[cti.a.p.em.event.v1.0~a.p.quota.reached.v1.0](em/licensing.raml#99-109)|Type|Event is raised when the quota is reached|
|[cti.a.p.em.event.v1.0~a.p.quota.update.v1.0](em/licensing.raml#112-123)|Type|Event is raised when the quota is updated|
|[cti.a.p.em.event.v1.0~a.p.setting.updated.v1.0](em/settings.raml#22-50)|Type|Event is raised when a setting for a tenant and domain object is updated.|
|[cti.a.p.em.event.v1.0~a.p.storage.fts_created.v1.0](em/storage.raml#20-27)|Type|The event is issued when FTS is registered|
|[cti.a.p.em.event.v1.0~a.p.storage.fts_deleted.v1.0](em/storage.raml#28-38)|Type|The event is issued when FTS registration is canceled|
|[cti.a.p.em.event.v1.0~a.p.storage.fts_updated.v1.0](em/storage.raml#39-45)|Type|The event is issued when FTS registration is updated|
|[cti.a.p.em.event.v1.0~a.p.subscription.activated.v0.1](em/subscription.raml#115-127)|Type|Event emitted when existing subscription is activated. The subject ID is the actual subscription's UUID. subject ID example: a8ef53fa-ad1d-4205-bcd6-27e509cd39b8 |
|[cti.a.p.em.event.v1.0~a.p.subscription.canceled.v0.1](em/subscription.raml#154-166)|Type|Event emitted when subscription has been canceled. The subject ID is the actual subscription's UUID. subject ID example: a8ef53fa-ad1d-4205-bcd6-27e509cd39b8 |
|[cti.a.p.em.event.v1.0~a.p.subscription.conflicted.v0.1](em/subscription.raml#232-243)|Type|Event emitted when a subscription enters into a conflicted state. The subject ID is the actual subscription's UUID. subject ID example: a8ef53fa-ad1d-4205-bcd6-27e509cd39b8 |
|[cti.a.p.em.event.v1.0~a.p.subscription.created.v0.1](em/subscription.raml#75-88)|Type|Event emitted when a new subscription is created. The subject ID is the actual subscription's UUID. Note: A created subscription does not mean that it's active. subject ID example: a8ef53fa-ad1d-4205-bcd6-27e509cd39b8 |
|[cti.a.p.em.event.v1.0~a.p.subscription.deactivated.v0.1](em/subscription.raml#128-140)|Type|Event emitted when existing subscription is deactivated. The subject ID is the actual subscription's UUID. subject ID example: a8ef53fa-ad1d-4205-bcd6-27e509cd39b8 |
|[cti.a.p.em.event.v1.0~a.p.subscription.deleted.v0.1](em/subscription.raml#102-114)|Type|Event emitted when a subscription is deleted. The subject ID is the actual subscription's UUID. subject ID example: a8ef53fa-ad1d-4205-bcd6-27e509cd39b8 |
|[cti.a.p.em.event.v1.0~a.p.subscription.downgraded.v0.1](em/subscription.raml#219-231)|Type|Event emitted when existing subscription has been downgraded. The subject ID is the actual subscription's UUID. subject ID example: a8ef53fa-ad1d-4205-bcd6-27e509cd39b8 |
|[cti.a.p.em.event.v1.0~a.p.subscription.expired.v0.1](em/subscription.raml#141-153)|Type|Event emitted when subscription has expired. The subject ID is the actual subscription's UUID. subject ID example: a8ef53fa-ad1d-4205-bcd6-27e509cd39b8 |
|[cti.a.p.em.event.v1.0~a.p.subscription.quota.updated.v0.1](em/subscription.raml#193-205)|Type|Event emitted when existing subscription's quota has been updated. The subject ID is the actual subscription's UUID. subject ID example: a8ef53fa-ad1d-4205-bcd6-27e509cd39b8 |
|[cti.a.p.em.event.v1.0~a.p.subscription.renewed.v0.1](em/subscription.raml#180-192)|Type|Event emitted when existing subscription has been renewed. The subject ID is the actual subscription's UUID. subject ID example: a8ef53fa-ad1d-4205-bcd6-27e509cd39b8 |
|[cti.a.p.em.event.v1.0~a.p.subscription.terminated.v0.1](em/subscription.raml#167-179)|Type|Event emitted when subscription has been terminated. The subject ID is the actual subscription's UUID. subject ID example: a8ef53fa-ad1d-4205-bcd6-27e509cd39b8 |
|[cti.a.p.em.event.v1.0~a.p.subscription.updated.v0.1](em/subscription.raml#89-101)|Type|Event emitted when a subscription was updated. The subject ID is the actual subscription's UUID. subject ID example: a8ef53fa-ad1d-4205-bcd6-27e509cd39b8 |
|[cti.a.p.em.event.v1.0~a.p.subscription.upgraded.v0.1](em/subscription.raml#206-218)|Type|Event emitted when existing subscription has been upgraded. The subject ID is the actual subscription's UUID. subject ID example: a8ef53fa-ad1d-4205-bcd6-27e509cd39b8 |
|[cti.a.p.em.event.v1.0~a.p.task.completed.v1.0](em/task.raml#25-43)|Type|Task complete event, `tenantid` - tenant's UUID, `subject` - task's UUID, `subjecttype` - task's type (if the type is in CTI format)|
|[cti.a.p.em.event.v1.0~a.p.task.started.v1.0](em/task.raml#44-60)|Type|Task started event, `tenantid` - tenant's UUID, `subject` - task's UUID, `subjecttype` - task's type (if the type is in CTI format)|
|[cti.a.p.em.event.v1.0~a.p.tenant.auth_consent.updated.v1.0](em/tenant.raml#210-217)|Type|Event is raised when tenant's authentication consent is updated.|
|[cti.a.p.em.event.v1.0~a.p.tenant.barrier_updated.v1.0](em/tenant.raml#112-127)|Type|Event generated when tenant barrier value is changed. Body contains new value.|
|[cti.a.p.em.event.v1.0~a.p.tenant.brand.updated.v1.0](em/tenant.raml#315-321)|Type|Event is raised when tenant brand is updated|
|[cti.a.p.em.event.v1.0~a.p.tenant.contact.deleted.v1.0](em/tenant.raml#194-209)|Type|Event is raised when tenant's contact is deleted.|
|[cti.a.p.em.event.v1.0~a.p.tenant.contact.updated.v1.0](em/tenant.raml#175-193)|Type|Event is raised when tenant's contact is updated.|
|[cti.a.p.em.event.v1.0~a.p.tenant.created.v1.0](em/tenant.raml#61-68)|Type|Event is raised when tenant is created|
|[cti.a.p.em.event.v1.0~a.p.tenant.deleted.v1.0](em/tenant.raml#39-60)|Type|Event is raised when tenant is removed (soft-deleted).  The consumers can use this event in order to hide this tenant and all the data associated with this tenant. The data should not be deleted permanently, but rather marked as deleted and so then the consumer can undelete it upon the cti.a.p.em.event.v1.0~a.p.tenant.undeleted.v1.0 event. This event is emitted for every tenant in the soft-deleted hierarchy, but only for the top tenant the hierarchy_root parameter will have true value |
|[cti.a.p.em.event.v1.0~a.p.tenant.disabled.v1.0](em/tenant.raml#77-84)|Type|Event is raised when tenant is disabled|
|[cti.a.p.em.event.v1.0~a.p.tenant.enabled.v1.0](em/tenant.raml#85-92)|Type|Event is raised when tenant is enabled|
|[cti.a.p.em.event.v1.0~a.p.tenant.hard_deleted.v1.0](em/tenant.raml#128-153)|Type|Event is raised when tenant is permanently removed. The consumers can use this event in order to delete this tenant and all the data associated with this tenant permanently. This operation can not be recovered. Normally, such events follow the cti.a.p.em.event.v1.0~a.p.tenant.deleted.v1.0 event after some retention (several days). This event is emitted for every tenant in the hard-deleted hierarchy, but only for the top tenant the hierarchy_root parameter will have true value |
|[cti.a.p.em.event.v1.0~a.p.tenant.locked.v1.0](em/tenant.raml#218-235)|Type|Event is raised when tenant is locked during an update, delete or undelete. Events emitted for all affected tenants |
|[cti.a.p.em.event.v1.0~a.p.tenant.moved.v1.0](em/tenant.raml#93-111)|Type|Event is raised when tenant is moved in tenants hierarchy|
|[cti.a.p.em.event.v1.0~a.p.tenant.pricing.trial_notification.v1.0](em/tenant.raml#274-295)|Type|Event is raised when the tenant's trial period is about to end in several days. It emits only for the customer type tenants with customer_types default(0) and small office(0).  The number of days remaining until the end of the trial period is configured in the app-account-server config. |
|[cti.a.p.em.event.v1.0~a.p.tenant.pricing.updated.v1.0](em/tenant.raml#244-273)|Type|Event is raised when tenant's pricing is updated. If the price is set for a customer tenant, it will be propagated to its unit tenants, and events for all affected unit tenants will be emitted. For other tenant types pricing will be set only for the specified tenant, and the event will be emitted only for this tenant.   |
|[cti.a.p.em.event.v1.0~a.p.tenant.setting.updated.v1.0](em/tenant.raml#296-313)|Type|Event is raised when some tenant's setting is updated. Emitted only for tenant who owns setting value. The updated setting name (string) is stored in the event header subject field. |
|[cti.a.p.em.event.v1.0~a.p.tenant.undeleted.v1.0](em/tenant.raml#154-174)|Type|Event is raised when tenant is restored from Recycle Bin (undeleted). The consumers can use this event in order to undelete this tenant and all the data associated with this tenant permanently. This event is emitted for every tenant in the undeleted hierarchy, but only for the top tenant the hierarchy_root parameter will have true value |
|[cti.a.p.em.event.v1.0~a.p.tenant.unlocked.v1.0](em/tenant.raml#236-243)|Type|Event is raised when tenant is unlocked|
|[cti.a.p.em.event.v1.0~a.p.tenant.updated.v1.0](em/tenant.raml#69-76)|Type|Event is raised when any tenant attributes are updated|
|[cti.a.p.em.event.v1.0~a.p.timeseries.v1.0](em/timeseries.raml#93-109)|Type|Defines a specific event containing set of timeseries dimension groups.<br/>Timeseries events may have timeseries groups for different subjects of  different subject types, thus timeseries events may be used for bunch  sending metrics acting as envelop. |
|[cti.a.p.em.event.v1.0~a.p.ui.log_message.v1.0](em/frontend_logs.raml#23-56)|Type|Log message event|
|[cti.a.p.em.event.v1.0~a.p.user.activated.v1.0](em/user.raml#103-109)|Type|Event is raised when user is activated|
|[cti.a.p.em.event.v1.0~a.p.user.contact.updated.v1.0](em/user.raml#79-86)|Type|Event is raised when user contact is updated|
|[cti.a.p.em.event.v1.0~a.p.user.created.v1.0](em/user.raml#31-38)|Type|Event is raised when user is created|
|[cti.a.p.em.event.v1.0~a.p.user.deleted.v1.0](em/user.raml#39-46)|Type|Event is raised when user is deleted|
|[cti.a.p.em.event.v1.0~a.p.user.disabled.v1.0](em/user.raml#95-102)|Type|Event is raised when user is disabled|
|[cti.a.p.em.event.v1.0~a.p.user.enabled.v1.0](em/user.raml#87-94)|Type|Event is raised when user is enabled|
|[cti.a.p.em.event.v1.0~a.p.user.hard_deleted.v1.0](em/user.raml#47-54)|Type|Event is raised when user is permanently removed (hard deleted)|
|[cti.a.p.em.event.v1.0~a.p.user.role_changed.v1.0](em/user.raml#71-78)|Type|Event is raised when user role is changed|
|[cti.a.p.em.event.v1.0~a.p.user.undeleted.v1.0](em/user.raml#55-62)|Type|Event is raised when user is restored from Recycle Bin (undeleted)|
|[cti.a.p.em.event.v1.0~a.p.user.updated.v1.0](em/user.raml#63-70)|Type|Event is raised when a user's attributes are updated, except for role changes and contact updates|
|[cti.a.p.em.msg.v1.0](em/types.raml#162-312)|Type|Defines the structure of the event that has occurred. Events will contain two types of information: the event data representing the occurrence and context metadata providing contextual information about the occurrence. A single occurrence may result in more than one event. Events are limited to a maximum size of 64KB, which includes both headers and payload. |
|[cti.a.p.em.timeseries.dimension.v1.0](em/timeseries.raml#36-77)|Type|Defines a set of values/readings associated with the list of time values.  Each dimension is associated with a specific subject type and  values use specific units. |
|[cti.a.p.em.topic.v1.0](em/types.raml#19-129)|Type|Event topic is a stream of events of the same or different types sharing the same delivery, ordering, consolidation & retention rules. |
|[cti.a.p.em.topic.v1.0~a.p.agent.v1.0](em/agent.raml#13-19)|Instance|Topic of notifications of events related to agents.|
|[cti.a.p.em.topic.v1.0~a.p.am.alerts.v1.0](em/alert.raml#16-23)|Instance|Alert Manager's alerts topic|
|[cti.a.p.em.topic.v1.0~a.p.app.cti_entities.v1.0](em/cti_entities.raml#14-21)|Instance|Topic for CTI entities metadata related events|
|[cti.a.p.em.topic.v1.0~a.p.app.cyberapp.v1.0](em/cyberapps.raml#13-20)|Instance|Topic for Cyber Application related events|
|[cti.a.p.em.topic.v1.0~a.p.audit.v1.0](em/audit.raml#11-18)|Instance|Account Server's tenant topic|
|[cti.a.p.em.topic.v1.0~a.p.client.v1.0](em/client.raml#15-22)|Instance|Account Server's API clients topic|
|[cti.a.p.em.topic.v1.0~a.p.events_from_agents.v1.0](em/agent.raml#20-27)|Instance|Topic of notifications of events produced by agents.|
|[cti.a.p.em.topic.v1.0~a.p.gr.records.v1.0](em/global_registry.raml#14-21)|Instance|Global Registry key-value storage topic|
|[cti.a.p.em.topic.v1.0~a.p.licensing.v1.0](em/licensing.raml#11-18)|Instance|Topic for all licensing-related events|
|[cti.a.p.em.topic.v1.0~a.p.policy.v1.0](em/policy.raml#11-18)|Instance|Policy Modification Events|
|[cti.a.p.em.topic.v1.0~a.p.sm.v1.0](em/settings.raml#13-20)|Instance|Settings Management's event topic|
|[cti.a.p.em.topic.v1.0~a.p.storage.v1.0](em/storage.raml#9-16)|Instance|Topic for events related to Storage Management|
|[cti.a.p.em.topic.v1.0~a.p.subscription.v0.1](em/subscription.raml#24-31)|Instance|Subscription Manager's subscription topic|
|[cti.a.p.em.topic.v1.0~a.p.task.v1.0](em/task.raml#14-21)|Instance|Task manager's task topic|
|[cti.a.p.em.topic.v1.0~a.p.tenant.v1.0](em/tenant.raml#28-35)|Instance|Account Server's tenant topic|
|[cti.a.p.em.topic.v1.0~a.p.timeseries.v1.0](em/timeseries.raml#11-18)|Instance|Base topic for timeseries events but Application should introduce it's own topics|
|[cti.a.p.em.topic.v1.0~a.p.ui.log.v1.0](em/frontend_logs.raml#12-19)|Instance|Topic for log message events produced by UI|
|[cti.a.p.em.topic.v1.0~a.p.user.v1.0](em/user.raml#20-27)|Instance|Account Server's user topic|

### Application Management

|Name|Kind|Description|
|---|---|---|
|[cti.a.p.app.application.meta.v1.0](app/application.raml#12-46)|Type|Application meta defines the integration specifics, for example whether the partner and customer mapping is required. |
|[cti.a.p.app.application.meta.v2.0](app/application_v2.raml#20-71)|Type|Application meta defines the application specifics traits. |
|[cti.a.p.app.application.meta.v2.0~a.p.application.meta.v1.0](app/application_v2.raml#12-18)|Instance|Application meta|
|[cti.a.p.app.connection.v1.0](app/connection.raml#31-46)|Type|Defines permissions that the service account created for the application will have. |
|[cti.a.p.app.customer_enablement.v1.0](app/enablement_flows/customer/customer.raml#15-70)|Type|Enablement flow on customer tenant level.|
|[cti.a.p.app.customer_enablement.v1.0~a.p.always_on.v1.0](app/enablement_flows/customer/always_on_v1/flow.raml#20-28)|Type|The flow means that entitites are enabled by default. In case always_on has a true value, this enablement type must be chosen. |
|[cti.a.p.app.customer_enablement.v1.0~a.p.authorization.v1.0](app/enablement_flows/customer/authorization_v2/flow.raml#31-51)|Type|Customer enablement authorization flow. Acronis customers mapped with particular creds onto tenants on Vendor's side. |
|[cti.a.p.app.customer_enablement.v1.0~a.p.explicit.v1.0](app/enablement_flows/customer/explicit_v2/flow.raml#18-24)|Type|Application is enabled on Acronis side explicitly and enablement state could be retrieved by the vendor using Application Manager API.  |
|[cti.a.p.app.customer_enablement.v1.0~a.p.mapping.v1.0](app/enablement_flows/customer/mapping_v2/flow.raml#34-58)|Type|Customer enablement mapping flow. Acronis customers mapped onto tenants on Vendor's side. |
|[cti.a.p.app.customer_enablement.v1.0~a.p.mirroring.v1.0](app/enablement_flows/customer/mirroring_v2/flow.raml#30-50)|Type|Customer enablement mirroring flow. Acronis customers mapped onto tenants on Vendor's side. |
|[cti.a.p.app.enablement_settings.customer.v1.0](app/enablement_flows/customer/settings.raml#15-24)|Type|Customer level application enablement settings. Vendor may want to provide own settings schema. |
|[cti.a.p.app.enablement_settings.partner.v1.0](app/enablement_flows/partner/settings.raml#15-24)|Type|Partner level application enablement settings. Vendor may want to provide own settings schema. |
|[cti.a.p.app.legacy_info.v1.0](app/legacy_info.raml#44-96)|Type|A base type for additional information on integrations that were created without CyberApp Standard. |
|[cti.a.p.app.manifest.v1.0](app/manifest.raml#21-36)|Type|Identifies the application package.|
|[cti.a.p.app.manifest.v1.0~a.p.manifest.v1.0](app/manifest.raml#15-17)|Instance|Acronis Platform application manifest.|
|[cti.a.p.app.marketing_info.v1.0](app/marketing_info.raml#85-223)|Type|A marketing information associated with an application.<br/>Instances of marketing information are provided within a separate marketing info package.<br/>Marketing information is associated with an application during the application deployment and the information will be displayed at the Solutions Portal and in the Integrations List. |
|[cti.a.p.app.marketing_info.v1.1](app/marketing_info_v1_1.raml#85-252)|Type|A marketing information associated with an application.<br/>Instances of marketing information are provided within a separate marketing info package.<br/>Marketing information is associated with an application during the application deployment and the information will be displayed at the Solutions Portal and in the Integrations List. |
|[cti.a.p.app.partner_enablement.v1.0](app/enablement_flows/partner/partner.raml#15-68)|Type|Partner enablement flow|
|[cti.a.p.app.partner_enablement.v1.0~a.p.always_on.v1.0](app/enablement_flows/partner/always_on_v1/flow.raml#20-28)|Type|The flow means that entitites are enabled by default. In case always_on has a true value, this enablement type must be chosen. |
|[cti.a.p.app.partner_enablement.v1.0~a.p.explicit.v1.0](app/enablement_flows/partner/explicit_v2/flow.raml#18-24)|Type|Application is enabled on Acronis side explicitly and enablement state could be retrieved by the vendor using Application Manager API.  |
|[cti.a.p.app.partner_enablement.v1.0~a.p.mapping.v1.0](app/enablement_flows/partner/mapping_v2/flow.raml#34-59)|Type|The flow implies that partner should provide credentials and extra information that will allow Vendor to authorize partner in Vendor's cloud. All callbacks, including ones performed on customer level should provide same partner authorization information in headers. |
|[cti.a.p.app.partner_enablement.v1.0~a.p.mirroring.v1.0](app/enablement_flows/partner/mirroring_v2/flow.raml#34-60)|Type|Vendor in that flow will create an entity on it's side and associate Acronis tenant with it. Currently only synchronous scenarios supported only, i.e. even if Vendor have not finished enablement process on it's side it should return ENABLED state. |
|[cti.a.p.app.service_user.configuration.v1.0](app/service_user.raml#15-44)|Type|Service user account configuration.|

### Alert Management

|Name|Kind|Description|
|---|---|---|
|[cti.a.p.am.alert.v1.0](am/types.raml#74-147)|Type|Base type for the alert.|
|[cti.a.p.am.alert.v1.0~a.p.basic.v1.0](am/types.raml#173-207)|Type|Base alert type with simplified presentation|
|[cti.a.p.am.category.v1.0](am/types.raml#148-166)|Type|An information about the alert category or alert type category.|

### API Callback Gateway

|Name|Kind|Description|
|---|---|---|
|[cti.a.p.acgw.callback.v1.0](acgw/callback_v1.raml#18-48)|Type|A callback is a contract between the platform and third-party service  that defines the request and responses' payloads and service-level agreement (SLA) options. |
|[cti.a.p.acgw.callback.v1.0~a.p.enablement.read.v1.0](app/enablement_flows/partner/mapping_v1/flow.raml#24-31)|Instance|Callback is used to get current enablement status and  receive an organization id already mapped to the Acronis tenant if any. |
|[cti.a.p.acgw.callback.v1.0~a.p.enablement.reset.v1.0](app/enablement_flows/partner/mapping_v1/flow.raml#40-45)|Instance|Callback allows partner to reset application enablement.|
|[cti.a.p.acgw.callback.v1.0~a.p.enablement.write.v1.0](app/enablement_flows/partner/mapping_v1/flow.raml#32-39)|Instance|Callback is used to enable application for the Acronis tenant  with certain organization id on a Vendor side. |
|[cti.a.p.acgw.callback.v1.0~a.p.tenant_mapping.read.v1.0](app/enablement_flows/customer/mapping_v1/flow.raml#24-29)|Instance|Tenant mapping read callback|
|[cti.a.p.acgw.callback.v1.0~a.p.tenant_mapping.write.v1.0](app/enablement_flows/customer/mapping_v1/flow.raml#30-35)|Instance|Tenant mapping write callback|
|[cti.a.p.acgw.callback.v1.0~a.p.topology.read.v1.0](app/enablement_flows/customer/mapping_v1/flow.raml#36-41)|Instance|Read Vendor's topology.|
|[cti.a.p.acgw.callback.v2.0](acgw/callback_v2.raml#20-55)|Type|A callback is a contract between the platform and third-party service  that defines the request and responses' payloads and service-level agreement (SLA) options. |
|[cti.a.p.acgw.callback.v2.0~a.p.customer.authorization.get_state.v1.0](app/enablement_flows/customer/authorization_v2/flow.raml#52-66)|Type|Get customer level application enablement state callback.|
|[cti.a.p.acgw.callback.v2.0~a.p.customer.authorization.set_state.v1.0](app/enablement_flows/customer/authorization_v2/flow.raml#103-117)|Type|Tenant authorization write callback|
|[cti.a.p.acgw.callback.v2.0~a.p.customer.mapping.get_state.v1.0](app/enablement_flows/customer/mapping_v2/flow.raml#59-76)|Type|Customer mapping get state callback. Callback called to ensure current state of the integration on the vendor side for the customers of Acronis partner passed in tenant_id field in the request context. |
|[cti.a.p.acgw.callback.v2.0~a.p.customer.mapping.set_state.v1.0](app/enablement_flows/customer/mapping_v2/flow.raml#122-138)|Type|Customer mapping set state callback. Application is enabled or disabled for customer of partner, passed in tenant_id context parameter. |
|[cti.a.p.acgw.callback.v2.0~a.p.customer.mirroring.get_state.v1.0](app/enablement_flows/customer/mirroring_v2/flow.raml#51-65)|Type|Get customer level application enablement state callback.|
|[cti.a.p.acgw.callback.v2.0~a.p.customer.mirroring.set_state.v1.0](app/enablement_flows/customer/mirroring_v2/flow.raml#101-115)|Type|Tenant mirroring write callback|
|[cti.a.p.acgw.callback.v2.0~a.p.partner.mapping.enable.v1.0](app/enablement_flows/partner/mapping_v2/flow.raml#118-133)|Type|Callback to enable application for partner tenant passed in request's context. |
|[cti.a.p.acgw.callback.v2.0~a.p.partner.mapping.get_state.v1.0](app/enablement_flows/partner/mapping_v2/flow.raml#60-76)|Type|Callback to retrieve current enablement state.|
|[cti.a.p.acgw.callback.v2.0~a.p.partner.mapping.reset.v1.0](app/enablement_flows/partner/mapping_v2/flow.raml#200-214)|Type|Application enablement reset callback.|
|[cti.a.p.acgw.callback.v2.0~a.p.partner.mirroring.enable.v1.0](app/enablement_flows/partner/mirroring_v2/flow.raml#117-131)|Type|Callback is used to enable application on partner level.|
|[cti.a.p.acgw.callback.v2.0~a.p.partner.mirroring.get_state.v1.0](app/enablement_flows/partner/mirroring_v2/flow.raml#61-77)|Type|Callback is used to read partner mirroring state.|
|[cti.a.p.acgw.callback.v2.0~a.p.partner.mirroring.reset.v1.0](app/enablement_flows/partner/mirroring_v2/flow.raml#197-211)|Type|Application enablement reset callback.|
|[cti.a.p.acgw.callback.v2.0~a.p.topology.read.v1.0](app/enablement_flows/customer/mapping_v2/flow.raml#203-218)|Type|Callback to retrieve topology of entities from Vendor platform |
|[cti.a.p.acgw.endpoint.v1.0](acgw/endpoint_v1.raml#18-83)|Type|A Callback Endpoint represents a logical web service implemented by a vendor.  While a Callback Endpoint supports multiple types of requests (Callback types - see below),  all requests to the Callback Endpoint will share the same security and authentication policy.  If required a single server may implement multiple Callback Endpoints. |
|[cti.a.p.acgw.endpoint.v1.1](acgw/endpoint_v1_1.raml#18-91)|Type|A Callback Endpoint represents a logical web service implemented by a vendor.  While a Callback Endpoint supports multiple types of requests (Callback types - see below),  all requests to the Callback Endpoint will share the same security and authentication policy.  If required a single server may implement multiple Callback Endpoints. |
|[cti.a.p.acgw.request.v1.0](acgw/request_v1.raml#48-95)|Type|Defines a callback request that is linked to the corresponding callback entities. Specifies the request payload for the callback. Additionally, the callback request may define which payload fields may be logged by Acronis. |
|[cti.a.p.acgw.request.v1.0~a.p.empty.v1.0](acgw/common.raml#15-19)|Type|Request without a body/payload|
|[cti.a.p.acgw.request.v1.0~a.p.enablement.write.v1.0](app/enablement_flows/partner/mapping_v1/flow.raml#69-87)|Type|Callback is used to enable application for the Acronis tenant with certain organization id on a Vendor side. |
|[cti.a.p.acgw.request.v1.0~a.p.tenant_mapping.write.v1.0](app/enablement_flows/customer/mapping_v1/flow.raml#66-90)|Type|Write tenant mapping|
|[cti.a.p.acgw.request.v1.0~a.p.topology.read.v1.0](app/enablement_flows/customer/mapping_v1/flow.raml#91-104)|Type|Vendor's topology request.|
|[cti.a.p.acgw.request.v1.1](acgw/request_v1_1.raml#51-112)|Type|Defines a callback request that is linked to the corresponding callback entities. Specifies the request payload for the callback. Additionally, the callback request may define which payload fields may be logged by Acronis. |
|[cti.a.p.acgw.request.v1.1~a.p.customer.authorization.get_state.v1.0](app/enablement_flows/customer/authorization_v2/flow.raml#67-72)|Type|Request to obtain enablement information on customer level.|
|[cti.a.p.acgw.request.v1.1~a.p.customer.authorization.set_state.v1.0](app/enablement_flows/customer/authorization_v2/flow.raml#118-171)|Type|Request to enable application on customer level by authorization of acronis tenant on Vendor platform. |
|[cti.a.p.acgw.request.v1.1~a.p.customer.mapping.get_state.v1.0](app/enablement_flows/customer/mapping_v2/flow.raml#77-91)|Type|Customer mapping get state request. Vendor should use tenant_id, passed in context and return mapping state for that tenant. |
|[cti.a.p.acgw.request.v1.1~a.p.customer.mapping.set_state.v1.0](app/enablement_flows/customer/mapping_v2/flow.raml#139-192)|Type|Customer mapping enablement request. Mapping state set for customer of partner, passed in tenant_id context parameter. |
|[cti.a.p.acgw.request.v1.1~a.p.customer.mirroring.get_state.v1.0](app/enablement_flows/customer/mirroring_v2/flow.raml#66-71)|Type|Request to obtain mirroring information on customer level.|
|[cti.a.p.acgw.request.v1.1~a.p.customer.mirroring.set_state.v1.0](app/enablement_flows/customer/mirroring_v2/flow.raml#116-162)|Type|Request to enable application on customer level by mirroring acronis tenant to Vendor platform. |
|[cti.a.p.acgw.request.v1.1~a.p.partner.mapping.enable.v1.0](app/enablement_flows/partner/mapping_v2/flow.raml#134-171)|Type|Application enablement request for the acronis tenant sent in the context. |
|[cti.a.p.acgw.request.v1.1~a.p.partner.mapping.get_state.v1.0](app/enablement_flows/partner/mapping_v2/flow.raml#77-82)|Type|Request to retrieve application enablement state.|
|[cti.a.p.acgw.request.v1.1~a.p.partner.mapping.reset.v1.0](app/enablement_flows/partner/mapping_v2/flow.raml#215-221)|Type|Request to reset application (disable) application. |
|[cti.a.p.acgw.request.v1.1~a.p.partner.mirroring.enable.v1.0](app/enablement_flows/partner/mirroring_v2/flow.raml#132-166)|Type|Request to enable partner tenant by mirroring Acronis tenant into Vendor platform. |
|[cti.a.p.acgw.request.v1.1~a.p.partner.mirroring.get_state.v1.0](app/enablement_flows/partner/mirroring_v2/flow.raml#78-83)|Type|Request to get application enablement state.|
|[cti.a.p.acgw.request.v1.1~a.p.partner.mirroring.reset.v1.0](app/enablement_flows/partner/mirroring_v2/flow.raml#212-217)|Type|Request to reset application (disable) application.|
|[cti.a.p.acgw.request.v1.1~a.p.topology.read.v1.0](app/enablement_flows/customer/mapping_v2/flow.raml#219-240)|Type|Vendor's topology request.|
|[cti.a.p.acgw.response.v1.0](acgw/request_v1.raml#15-47)|Type|Defines a callback responses that is linked to the corresponding callback entities. Specifies the response HTTP code and payload for the callback. Additionally, the callback response may define which payload fields may be logged by Acronis. |
|[cti.a.p.acgw.response.v1.0~a.p.acgw.bad_request.v1.0](acgw/gateway_errors.raml#214-225)|Type|ACGW Bad Request.|
|[cti.a.p.acgw.response.v1.0~a.p.acgw.forbidden.v1.0](acgw/gateway_errors.raml#238-249)|Type|ACGW Forbidden.|
|[cti.a.p.acgw.response.v1.0~a.p.acgw.internal_error.v1.0](acgw/gateway_errors.raml#226-237)|Type|ACGW Internal Server error.|
|[cti.a.p.acgw.response.v1.0~a.p.acgw.not_found.v1.0](acgw/gateway_errors.raml#250-260)|Type|ACGW Not Found.|
|[cti.a.p.acgw.response.v1.0~a.p.enablement.read.ok.v1.0](app/enablement_flows/partner/mapping_v1/flow.raml#49-68)|Type|Indicate successful response|
|[cti.a.p.acgw.response.v1.0~a.p.request.schema_error.v1.0](acgw/gateway_errors.raml#130-141)|Type|Response schema error|
|[cti.a.p.acgw.response.v1.0~a.p.response.schema_error.v1.0](acgw/gateway_errors.raml#142-153)|Type|Callback's request schema error|
|[cti.a.p.acgw.response.v1.0~a.p.success_no_content.v1.0](acgw/common.raml#20-26)|Type|Successful response without a body/payload|
|[cti.a.p.acgw.response.v1.0~a.p.tenant_mapping.read.ok.v1.0](app/enablement_flows/customer/mapping_v1/flow.raml#45-65)|Type|Successful response with list of mapped tenants.|
|[cti.a.p.acgw.response.v1.0~a.p.topology.read.ok.v1.0](app/enablement_flows/customer/mapping_v1/flow.raml#105-132)|Type|Successful response with list of Vendor's topology objects|
|[cti.a.p.acgw.response.v1.0~a.p.upstream.4xx_error.v1.0](acgw/gateway_errors.raml#154-165)|Type|Unexpected 4XX error|
|[cti.a.p.acgw.response.v1.0~a.p.upstream.5xx_error.v1.0](acgw/gateway_errors.raml#166-177)|Type|Upstream 5XX error|
|[cti.a.p.acgw.response.v1.0~a.p.upstream.connection_timeout.v1.0](acgw/gateway_errors.raml#94-105)|Type|Gateway timed out contacting the origin server|
|[cti.a.p.acgw.response.v1.0~a.p.upstream.forbidden.v1.0](acgw/gateway_errors.raml#190-201)|Type|Upstream 403 Forbidden|
|[cti.a.p.acgw.response.v1.0~a.p.upstream.invalid_response.v1.0](acgw/gateway_errors.raml#118-129)|Type|Unexpected non-error HTTP code 2XX-3XX, e.g.  302 Found  2XX-3XX|
|[cti.a.p.acgw.response.v1.0~a.p.upstream.refused_connection.v1.0](acgw/gateway_errors.raml#58-69)|Type|Connection refused|
|[cti.a.p.acgw.response.v1.0~a.p.upstream.service_disabled.v1.0](acgw/gateway_errors.raml#202-213)|Type|Upstream 410 Gone error. Service deactivated.|
|[cti.a.p.acgw.response.v1.0~a.p.upstream.timeout.v1.0](acgw/gateway_errors.raml#106-117)|Type|Gateway was able to complete a TCP connection to the origin server, but did not receive a timely HTTP response|
|[cti.a.p.acgw.response.v1.0~a.p.upstream.tls.certificate_error.v1.0](acgw/gateway_errors.raml#82-93)|Type|Gateway could not validate the SSL certificate on the origin web server|
|[cti.a.p.acgw.response.v1.0~a.p.upstream.tls.handshake_error.v1.0](acgw/gateway_errors.raml#70-81)|Type|TLS Handshake Failed|
|[cti.a.p.acgw.response.v1.0~a.p.upstream.unauthorized.v1.0](acgw/gateway_errors.raml#178-189)|Type|Upstream 401 Unauthorized|
|[cti.a.p.acgw.response.v1.0~a.p.upstream.unreachable.v1.0](acgw/gateway_errors.raml#46-57)|Type|Unreachable server|
|[cti.a.p.acgw.response.v1.1](acgw/request_v1_1.raml#15-50)|Type|Defines a callback responses that is linked to the corresponding callback entities. Specifies the response HTTP code and payload for the callback. Additionally, the callback response may define which payload fields may be logged by Acronis. |
|[cti.a.p.acgw.response.v1.1~a.p.customer.authorization.get_state.ok.v1.0](app/enablement_flows/customer/authorization_v2/flow.raml#73-102)|Type|Successful response with list of mapped tenants.|
|[cti.a.p.acgw.response.v1.1~a.p.customer.authorization.set_state.ok.v1.0](app/enablement_flows/customer/authorization_v2/flow.raml#172-198)|Type|Response on successful authorization request.|
|[cti.a.p.acgw.response.v1.1~a.p.customer.mapping.get_state.ok.v1.0](app/enablement_flows/customer/mapping_v2/flow.raml#92-121)|Type|Successful response with list of mapped tenants. |
|[cti.a.p.acgw.response.v1.1~a.p.customer.mapping.set_state.ok.v1.0](app/enablement_flows/customer/mapping_v2/flow.raml#193-202)|Type|Successful response ....|
|[cti.a.p.acgw.response.v1.1~a.p.customer.mirroring.get_state.ok.v1.0](app/enablement_flows/customer/mirroring_v2/flow.raml#72-100)|Type|Successful response with list of mapped tenants.|
|[cti.a.p.acgw.response.v1.1~a.p.customer.mirroring.set_state.ok.v1.0](app/enablement_flows/customer/mirroring_v2/flow.raml#163-170)|Type|Response on successful mirroring requested customer tenants.|
|[cti.a.p.acgw.response.v1.1~a.p.partner.mapping.enable.ok.v1.0](app/enablement_flows/partner/mapping_v2/flow.raml#172-199)|Type|Read partner enablement state|
|[cti.a.p.acgw.response.v1.1~a.p.partner.mapping.get_state.ok.v1.0](app/enablement_flows/partner/mapping_v2/flow.raml#83-117)|Type|Partner enablement state.|
|[cti.a.p.acgw.response.v1.1~a.p.partner.mapping.reset.ok.v1.0](app/enablement_flows/partner/mapping_v2/flow.raml#222-229)|Type|Indicates successful application enablement reset.|
|[cti.a.p.acgw.response.v1.1~a.p.partner.mirroring.enable.ok.v1.0](app/enablement_flows/partner/mirroring_v2/flow.raml#167-196)|Type|Vendor may return tenant ID that will be associated to Acronis tenant in request context. If Application defines partner level enablement settings it should be returned as well. Right now only synchronous scenarios supported. |
|[cti.a.p.acgw.response.v1.1~a.p.partner.mirroring.get_state.ok.v1.0](app/enablement_flows/partner/mirroring_v2/flow.raml#84-116)|Type|Vendor should return tenant on it's side associated to Acronis tenant passed in context if integration enabled. If Application defines partner level enablement settings it should be returned as well. |
|[cti.a.p.acgw.response.v1.1~a.p.partner.mirroring.reset.ok.v1.0](app/enablement_flows/partner/mirroring_v2/flow.raml#218-225)|Type|Indicates successful application enablement reset.|
|[cti.a.p.acgw.response.v1.1~a.p.topology.read.ok.v1.0](app/enablement_flows/customer/mapping_v2/flow.raml#241-263)|Type|Successful response with list of Vendor's topology objects|

### Backend for Frontend

|Name|Kind|Description|
|---|---|---|
|[cti.a.p.bff.definition.v0.1](bff/types.raml#17-30)|Type|Base type for definitions used by BFF/GQLGateway service|
|[cti.a.p.bff.dictionary.v0.1](bff/types.raml#31-42)|Type|Base type for dictionaries to be used in BFF|

### Settings Management

|Name|Kind|Description|
|---|---|---|
|[cti.a.p.sm.setting.v1.0](sm/types.raml#274-330)|Type|A base type for the setting.|
|[cti.a.p.sm.setting.v1.0~a.p.acgw.logs.v1.0](acgw/settings.raml#49-78)|Type|New setting doesn't use Namespace|
|[cti.a.p.sm.setting.v1.0~a.p.acgw.vendor.data.v1.0](acgw/settings.raml#18-48)|Type|New setting doesn't use Namespace|
|[cti.a.p.sm.setting.v1.0~a.p.app_enablement.customer.v1.0](app/enablement_flows/customer/settings.raml#25-45)|Type|Customer level application enablement settings in Settings service. |
|[cti.a.p.sm.setting.v1.0~a.p.app_enablement.partner.v1.0](app/enablement_flows/partner/settings.raml#25-45)|Type|Partner level application enablement settings in Settings service. |

### Storage Management

|Name|Kind|Description|
|---|---|---|
|[cti.a.p.stm.infra.v1.0](stm/infra.raml#16-87)|Type|A base type for the infrastructure component.|
|[cti.a.p.stm.location.v1.0](stm/location.raml#10-39)|Type|A base type for the infrastructure location.|
|[cti.a.p.stm.s3.delete_url.v1.0](stm/s3_signed_url.raml#140-148)|Type|Delete request body|
|[cti.a.p.stm.s3.download_url.v1.0](stm/s3_signed_url.raml#18-27)|Type|Download request body|
|[cti.a.p.stm.s3.head_object_url.v1.0](stm/s3_signed_url.raml#8-17)|Type|Head to object request body|
|[cti.a.p.stm.s3.list_objects_url.v1.0](stm/s3_signed_url.raml#123-139)|Type|List objects request body|
|[cti.a.p.stm.s3.upload_url.v1.0](stm/s3_signed_url.raml#28-38)|Type|A base type for the S3 upload URL.|
|[cti.a.p.stm.s3.upload_url.v1.0~a.p.complete_multipart_upload.v1.0](stm/s3_signed_url.raml#101-122)|Type|end multipart upload request body|
|[cti.a.p.stm.s3.upload_url.v1.0~a.p.create_multipart_upload.v1.0](stm/s3_signed_url.raml#55-70)|Type|create multipart upload request body|
|[cti.a.p.stm.s3.upload_url.v1.0~a.p.upload_object.v1.0](stm/s3_signed_url.raml#39-54)|Type|upload request body|
|[cti.a.p.stm.s3.upload_url.v1.0~a.p.upload_part.v1.0](stm/s3_signed_url.raml#71-89)|Type|upload request body|
|[cti.a.p.stm.s3_buckets_pool.v1.0](stm/s3_buckets_pool.raml#15-90)|Type|Pool of s3 buckets. Each bucket in a pool has name which matches template {pool name}-{bucket number},  where {bucket number} is an integer value in a range from 0 to {buckets_count} |

### Policy Management

|Name|Kind|Description|
|---|---|---|
|[cti.a.p.pm.policy.v1.0](pm/types.raml#107-196)|Type|Identifiable and (optionally) named set of rules or settings. For some policies their rules / settings are specially organized to enable easy 're-use' in context of different and multiple 'resources'. Such policies must be bound to a context during application. But that is not the only case and policies may exist, which do not require binding to any additional contexts during application. |
|[cti.a.p.pm.policy.v1.0~a.p.composite.v1.0](pm/types.raml#226-238)|Type|Policy can be linked to other policies making a policy composite. Policy composite is always an acyclic directed graph with a single 'root'. Composite policy 'root' does not have parents. Non-root policy within a composite may have multiple 'parents' (which it's linked to) and multiple 'children' (which are linked to it). |
|[cti.a.p.pm.policy.v1.0~a.p.section.v1.0](pm/types.raml#197-225)|Type|Policy section is a signle policy that is part of a composite (sub-policy). |
|[cti.a.p.pm.policy.v1.0~a.p.section.v1.0~a.p.backup.disk.v1.0](pm/derived/backup.raml#22-30)|Type|Policy section containing disk backup settings|
|[cti.a.p.pm.policy.v1.0~a.p.section.v1.0~a.p.backup.machine.v1.0](pm/derived/backup.raml#31-39)|Type|Policy section containing machine backup settings|
|[cti.a.p.pm.policy.v1.0~a.p.section.v1.0~a.p.backup.replication.v1.0](pm/derived/backup.raml#49-57)|Type|Policy section containing backup replication settings|
|[cti.a.p.pm.policy.v1.0~a.p.section.v1.0~a.p.backup.retention.v1.0](pm/derived/backup.raml#58-65)|Type|Policy section containing backup retention settings|
|[cti.a.p.pm.policy.v1.0~a.p.section.v1.0~a.p.backup.system_state.v1.0](pm/derived/backup.raml#40-48)|Type|Policy section containing system state backup settings|
|[cti.a.p.pm.policy.v1.0~a.p.section.v1.0~a.p.cdp.v1.0](pm/derived/backup.raml#13-21)|Type|Policy section containing continious data protection settings|
|[cti.a.p.pm.policy.v1.0~a.p.section.v1.0~a.p.cyberfit.compliance.v1.0](pm/derived/cyberfit.raml#10-18)|Type|Policy section containing cyberfit compliance settings|
|[cti.a.p.pm.policy.v1.0~a.p.section.v1.0~a.p.cyberfit.configuration.v1.0](pm/derived/cyberfit.raml#19-26)|Type|Policy section containing cyberfit configuration settings|
|[cti.a.p.pm.policy.v1.0~a.p.section.v1.0~a.p.inventory.hardware.v1.0](pm/derived/inventory.raml#10-18)|Type|Policy section containing hardware inventory settings|
|[cti.a.p.pm.policy.v1.0~a.p.section.v1.0~a.p.inventory.software.v1.0](pm/derived/inventory.raml#19-26)|Type|Policy section containing software inventory settings|
|[cti.a.p.pm.policy.v1.0~a.p.section.v1.0~a.p.machine.firewall_management.v1.0](pm/derived/machine.raml#10-18)|Type|Policy section containing firewall management settings|
|[cti.a.p.pm.policy.v1.0~a.p.section.v1.0~a.p.machine.network_isolation.v1.0](pm/derived/machine.raml#19-26)|Type|Policy section containing network isolation settings|
|[cti.a.p.pm.policy.v1.0~a.p.section.v1.0~a.p.management.agent.v1.0](pm/derived/management.raml#9-18)|Type|Policy section containing remote management settings|
|[cti.a.p.pm.policy.v1.0~a.p.section.v1.0~a.p.recovery.file.v1.0](pm/derived/recovery.raml#18-25)|Type|Policy section containing file recovery settings|
|[cti.a.p.pm.policy.v1.0~a.p.section.v1.0~a.p.recovery.image.v1.0](pm/derived/recovery.raml#9-17)|Type|Policy section containing image recovery settings|
|[cti.a.p.pm.policy.v1.0~a.p.section.v1.0~a.p.security.active_protection.v1.0](pm/derived/security.raml#18-26)|Type|Policy section containing active protection settings|
|[cti.a.p.pm.policy.v1.0~a.p.section.v1.0~a.p.security.antimalware_protection.v1.0](pm/derived/security.raml#27-35)|Type|Policy section containing antimalware protection settings|
|[cti.a.p.pm.policy.v1.0~a.p.section.v1.0~a.p.security.backups_scanning.v1.0](pm/derived/security.raml#36-44)|Type|Policy section containing backups scanning settings|
|[cti.a.p.pm.policy.v1.0~a.p.section.v1.0~a.p.security.data_protection_map.v1.0](pm/derived/security.raml#45-53)|Type|Policy section containing data protection settings|
|[cti.a.p.pm.policy.v1.0~a.p.section.v1.0~a.p.security.edr.v1.0](pm/derived/security.raml#54-62)|Type|Policy section containing EDR settings|
|[cti.a.p.pm.policy.v1.0~a.p.section.v1.0~a.p.security.microsoft_security_essentials.v1.0](pm/derived/security.raml#63-71)|Type|Policy section containing microsoft security essentials settings|
|[cti.a.p.pm.policy.v1.0~a.p.section.v1.0~a.p.security.patch_management.v1.0](pm/derived/security.raml#72-80)|Type|Policy section containing patch management settings|
|[cti.a.p.pm.policy.v1.0~a.p.section.v1.0~a.p.security.url_filtering.v1.0](pm/derived/security.raml#81-89)|Type|Policy section containing url filtering settings|
|[cti.a.p.pm.policy.v1.0~a.p.section.v1.0~a.p.security.vulnerability_assessment.v1.0](pm/derived/security.raml#90-98)|Type|Policy section containing vulnerability assessment settings|
|[cti.a.p.pm.policy.v1.0~a.p.section.v1.0~a.p.security.windows_defender.v1.0](pm/derived/security.raml#99-106)|Type|Policy section containing windows defender settings|

### Workload Management

|Name|Kind|Description|
|---|---|---|
|[cti.a.p.wm.action.v0.1](wm/types.raml#257-270)|Type|TBD|
|[cti.a.p.wm.action.v0.1~a.p.backup.computer.v1.0](wm/derived/actions.raml#8-9)|Instance|TBD|
|[cti.a.p.wm.action.v0.1~a.p.backup.virtual_machine.vmwesx.v1.0](wm/derived/actions.raml#12-14)|Instance|TBD|
|[cti.a.p.wm.action.v0.1~a.p.recovery.computer.v1.0](wm/derived/actions.raml#10-11)|Instance|TBD|
|[cti.a.p.wm.aggregates_detection_query.attribute_condition_key.v1.0](wm/types.raml#271-284)|Type|TBD|
|[cti.a.p.wm.aggregates_detection_query.attribute_condition_key.v1.0~a.p.host_name.v1.0](wm/derived/machine/aggregates.raml#12-13)|Instance|TBD|
|[cti.a.p.wm.aggregates_detection_query.attribute_condition_key.v1.0~a.p.mac_address.v1.0](wm/derived/machine/aggregates.raml#14-16)|Instance|TBD|
|[cti.a.p.wm.workload.actions.v0.1](wm/types.raml#285-312)|Type|TBD|
|[cti.a.p.wm.workload.actions.v0.1~a.p.wm.machine.actions.v1.0](wm/derived/actions.raml#16-21)|Instance|TBD|
|[cti.a.p.wm.workload.actions.v0.1~a.p.wm.virtual_machine.vmwesx.actions.v1.0](wm/derived/actions.raml#22-26)|Instance|TBD|
|[cti.a.p.wm.workload.v1.0](wm/types.raml#345-468)|Type|Any resource valuable for the customer, and for which Acronis Platform and its extensions can add value.<br/>Typically originates in an external (customer-owned) system or is in any other way owned by customer. Identifiable and having a granularity enough to be easy to track by the customer. Actions executed on the workload, that change status important to the customer, can be configured either per workload or via policies. In the latter case, multiple policies (i.e., multiple rules / settings sets) may be configured for the workload simultaneously.<br/>Workloads can be aspects, aggregates or groups (including customer-created static or dynamic groups), the boundaries between the kinds are often blurred. All the workload kinds share the same identifiers space.<br/>From policies perspective, workloads serve as contexts, where policy rules / settings are applied and executed. |
|[cti.a.p.wm.workload.v1.0~a.p.wm.aggregate.v1.0](wm/types.raml#499-516)|Type|Aggregate workload is a special group (aggregation) of aspect workloads that represent logically the same workload. Aspects can be merged into the aggregate, or the aggregate can be split back into an individual aspects. |
|[cti.a.p.wm.workload.v1.0~a.p.wm.aggregate.v1.0~a.p.machine.v1.0](wm/derived/machine/aggregates.raml#18-28)|Type|Aggregate machine with a physical workload type|
|[cti.a.p.wm.workload.v1.0~a.p.wm.aspect.v1.0](wm/types.raml#473-498)|Type|Aspect workload is any workload managed by some agent or vendor connector. Aspect may have children workload (thus being a group, effectively) - e.g. for cluster-like workload case, virtual machine infrastructure workload case etc. |
|[cti.a.p.wm.workload.v1.0~a.p.wm.aspect.v1.0~a.p.machine.v1.0](wm/derived/machine/aspects.raml#12-34)|Type|Aspect for machine with a physical workload type (Physical, EsxVirtual, EsxVirtualHost, VmWareVirtual, HyperVirtual, ParallelsVirtual, MsVpcVirtual...)|
|[cti.a.p.wm.workload.v1.0~a.p.wm.aspect.v1.0~a.p.msexchange_mailbox.msexchange.v1.0](wm/derived/msexchange_mailbox.msexchange/aspects.raml#12-26)|Type|Aspect for MS Exchange mailbox|
|[cti.a.p.wm.workload.v1.0~a.p.wm.aspect.v1.0~a.p.msexchange_mailbox.office365.v1.0](wm/derived/msexchange_mailbox.office365/aspects.raml#12-24)|Type|Aspect for MS Exchange Office365 mailbox|
|[cti.a.p.wm.workload.v1.0~a.p.wm.aspect.v1.0~a.p.mssql_database.v1.0](wm/derived/mssql_database/aspects.raml#12-24)|Type|Aspect workload for MsSql databases|
|[cti.a.p.wm.workload.v1.0~a.p.wm.aspect.v1.0~a.p.virtual_machine.mshyperv.v1.0](wm/derived/virtual_machine.mshyperv/aspects.raml#12-24)|Type|Aspect workload for Microsoft HyperV type. Hyper-V is a hypervisor-based virtualization program from Microsoft for 64 bit systems with AMD-V or Intel VT processors.|
|[cti.a.p.wm.workload.v1.0~a.p.wm.aspect.v1.0~a.p.virtual_machine.vmwesx.v1.0](wm/derived/virtual_machine.vmwesx/aspects.raml#12-24)|Type|Aspect workload for VMWare ESX type. VMware ESX is an enterprise-level computer virtualization product offered by VMware.|
|[cti.a.p.wm.workload.v1.0~a.p.wm.group.v1.0](wm/types.raml#517-537)|Type|Though aspects may have children, workload group is dedicated to grouping only, with 2 specific sub-cases: - group explicitly created by a customer, with explicit (static group) or automatic   (dynamic group) membership - top-level group |
|[cti.a.p.wm.workload.v1.0~a.p.wm.group.v1.0~a.p.computers.v1.0](wm/derived/top_level_groups.raml#8-15)|Type|Group composed of computer type workloads|
|[cti.a.p.wm.workload.v1.0~a.p.wm.group.v1.0~a.p.msexchange_mailboxes.v1.0](wm/derived/top_level_groups.raml#16-23)|Type|Group composed of MS Exchange mailbox type workloads|
|[cti.a.p.wm.workload.v1.0~a.p.wm.group.v1.0~a.p.vms_folder.v1.0](wm/derived/top_level_groups.raml#24-30)|Type|Group composed of virtual machine folders type workloads|

### Widgets and Reports

|Name|Kind|Description|
|---|---|---|
|[cti.a.p.wr.dashboard_config.v1.0](wr/types.raml#676-705)|Type|Dashboard configuration|
|[cti.a.p.wr.dashboard_config.v1.0~a.p.mc.default_dashboard.v1.0](wr/widget_configs.raml#641-647)|Instance|Management Console default dashboard|
|[cti.a.p.wr.dashboard_config.v1.0~a.p.pc.default_dashboard.v1.0](wr/widget_configs.raml#633-640)|Instance|Protection Console default dashboard|
|[cti.a.p.wr.report_config.v1.0](wr/types.raml#706-741)|Type|Report configuration|
|[cti.a.p.wr.report_config.v1.0~a.p.mc.alerts_report.v1.0](wr/widget_configs.raml#552-561)|Instance|Shows alerts that occurred during a specified time period.|
|[cti.a.p.wr.report_config.v1.0~a.p.mc.detected_threats_report.v1.0](wr/widget_configs.raml#562-571)|Instance|Detected threats report displays the details of the affected machines by number of blocked threats and the details of the healthy and vulnerable machines.|
|[cti.a.p.wr.report_config.v1.0~a.p.mc.existing_vulnerabilities_report.v1.0](wr/widget_configs.raml#572-581)|Instance|Existing vulnerabilities lists the existing vulnerabilities for OS and applications in your organization. The report also displays the details of the affected machines in your network for every product that is listed.|
|[cti.a.p.wr.report_config.v1.0~a.p.mc.hardware_inventory_report.v1.0](wr/widget_configs.raml#582-591)|Instance|Hardware inventory report shows information about the hardware installed on the machines in your organization.|
|[cti.a.p.wr.report_config.v1.0~a.p.mc.patch_management_report.v1.0](wr/widget_configs.raml#592-601)|Instance|Patch management summary report lists down the number of missing patches, installed patches, applicable patches. You can drill down the reports to get the missing/installed patch information and details of all the systems.|
|[cti.a.p.wr.report_config.v1.0~a.p.mc.session_history_report.v1.0](wr/widget_configs.raml#602-611)|Instance|Shows the detailed information about the performed remote desktop and file transfer sessions during a specified time period.|
|[cti.a.p.wr.report_config.v1.0~a.p.mc.software_inventory_report.v1.0](wr/widget_configs.raml#612-621)|Instance|Software inventory report shows information about the software installed on the machines in your organization.|
|[cti.a.p.wr.report_config.v1.0~a.p.mc.summary_report.v1.0](wr/widget_configs.raml#622-631)|Instance|Shows the summary information about the protected devices for a specified time period.|
|[cti.a.p.wr.report_config.v1.0~a.p.pc.alerts_report.v1.0](wr/widget_configs.raml#460-469)|Instance|Shows alerts that occurred during a specified time period.|
|[cti.a.p.wr.report_config.v1.0~a.p.pc.data_loss_prevention_report.v1.0](wr/widget_configs.raml#540-551)|Instance|Data loss prevention report.|
|[cti.a.p.wr.report_config.v1.0~a.p.pc.detected_threats_report.v1.0](wr/widget_configs.raml#470-479)|Instance|Detected threats report displays the details of the affected machines by number of blocked threats and the details of the healthy and vulnerable machines.|
|[cti.a.p.wr.report_config.v1.0~a.p.pc.existing_vulnerabilities_report.v1.0](wr/widget_configs.raml#480-489)|Instance|Existing vulnerabilities lists the existing vulnerabilities for OS and applications in your organization. The report also displays the details of the affected machines in your network for every product that is listed.|
|[cti.a.p.wr.report_config.v1.0~a.p.pc.hardware_inventory_report.v1.0](wr/widget_configs.raml#490-499)|Instance|Hardware inventory report shows information about the hardware installed on the machines in your organization.|
|[cti.a.p.wr.report_config.v1.0~a.p.pc.patch_management_report.v1.0](wr/widget_configs.raml#500-509)|Instance|Patch management summary report lists down the number of missing patches, installed patches, applicable patches. You can drill down the reports to get the missing/installed patch information and details of all the systems.|
|[cti.a.p.wr.report_config.v1.0~a.p.pc.session_history_report.v1.0](wr/widget_configs.raml#510-519)|Instance|Shows the detailed information about the performed remote desktop and file transfer sessions during a specified time period.|
|[cti.a.p.wr.report_config.v1.0~a.p.pc.software_inventory_report.v1.0](wr/widget_configs.raml#520-529)|Instance|Software inventory report shows information about the software installed on the machines in your organization.|
|[cti.a.p.wr.report_config.v1.0~a.p.pc.summary_report.v1.0](wr/widget_configs.raml#530-539)|Instance|Shows the summary information about the protected devices for a specified time period.|
|[cti.a.p.wr.widget_category.v1.0](wr/types.raml#88-105)|Type|Widget category|
|[cti.a.p.wr.widget_category.v1.0~a.p.activities.v1.0](wr/widget_configs.raml#16-18)|Instance|Activities|
|[cti.a.p.wr.widget_category.v1.0~a.p.alerts.v1.0](wr/widget_configs.raml#10-12)|Instance|Alerts|
|[cti.a.p.wr.widget_category.v1.0~a.p.cyberfit_score.v1.0](wr/widget_configs.raml#22-24)|Instance|#CyberFit Score|
|[cti.a.p.wr.widget_category.v1.0~a.p.data_loss_prevention.v1.0](wr/widget_configs.raml#25-27)|Instance|Data loss prevention|
|[cti.a.p.wr.widget_category.v1.0~a.p.data_protection_map.v1.0](wr/widget_configs.raml#28-30)|Instance|Data protection map|
|[cti.a.p.wr.widget_category.v1.0~a.p.devices.v1.0](wr/widget_configs.raml#13-15)|Instance|Devices|
|[cti.a.p.wr.widget_category.v1.0~a.p.disk_health.v1.0](wr/widget_configs.raml#31-33)|Instance|Disk health|
|[cti.a.p.wr.widget_category.v1.0~a.p.hardware.v1.0](wr/widget_configs.raml#34-36)|Instance|Hardware|
|[cti.a.p.wr.widget_category.v1.0~a.p.locations.v1.0](wr/widget_configs.raml#37-39)|Instance|Locations|
|[cti.a.p.wr.widget_category.v1.0~a.p.patch_management.v1.0](wr/widget_configs.raml#40-42)|Instance|Patch Management|
|[cti.a.p.wr.widget_category.v1.0~a.p.remote_access.v1.0](wr/widget_configs.raml#43-45)|Instance|Remote access|
|[cti.a.p.wr.widget_category.v1.0~a.p.software.v1.0](wr/widget_configs.raml#46-48)|Instance|Software|
|[cti.a.p.wr.widget_category.v1.0~a.p.threat_defence.v1.0](wr/widget_configs.raml#19-21)|Instance|Threat defence|
|[cti.a.p.wr.widget_category.v1.0~a.p.url_filtering.v1.0](wr/widget_configs.raml#49-51)|Instance|URL Filtering|
|[cti.a.p.wr.widget_category.v1.0~a.p.vulnerability_assessment.v1.0](wr/widget_configs.raml#52-55)|Instance|Vulnerability assessment|
|[cti.a.p.wr.widget_config.v1.0](wr/types.raml#447-659)|Type|Represents base widget configuration model. All the widget configurations will be instance from this.|
|[cti.a.p.wr.widget_config.v1.0~a.p.active_alerts_summary.v1.0](wr/widget_configs.raml#141-205)|Instance|Active alerts summary|
|[cti.a.p.wr.widget_config.v1.0~a.p.active_alerts_table.v1.0](wr/widget_configs.raml#289-369)|Instance|Active Alerts|
|[cti.a.p.wr.widget_config.v1.0~a.p.alerts_summary.v1.0](wr/widget_configs.raml#58-140)|Instance|Historical alerts summary|
|[cti.a.p.wr.widget_config.v1.0~a.p.all_units_active_alerts.v1.0](wr/widget_configs.raml#413-457)|Instance|All Units Active Alerts|
|[cti.a.p.wr.widget_config.v1.0~a.p.all_units_alerts_summary.v1.0](wr/widget_configs.raml#370-412)|Instance|All Units Active Alerts Summary|
|[cti.a.p.wr.widget_config.v1.0~a.p.summary_alert_table.v1.0](wr/widget_configs.raml#206-288)|Instance|Alerts History|

### Dynamic Type System

|Name|Kind|Description|
|---|---|---|
|[cti.a.p.dts.func.v1.0](dts/types.raml#475-506)|Type|DTS function can be used to define a function interface and/or it's body. The interface is defined this way: - `params` specifies function input parameters if any - `returns` define return value - `cti-traits` define function implementation, which can be both declarative and imperative (SERVERLESS_WORKFLOW, GO, etc.) |
|[cti.a.p.dts.func.v1.0~a.p.access_policies._roles_ids_.any_of.v1.0](dts/func/access_policies/_roles_ids_/any_of.raml#11-35)|Type|Checks if any of the role ids given is in the requesting user's access policies.|
|[cti.a.p.dts.func.v1.0~a.p.access_policies.company_admin.is.v1.0](dts/func/access_policies/company_admin/is.raml#11-26)|Type|Checks if any company admin role is in the requesting user's access policies.|
|[cti.a.p.dts.func.v1.0~a.p.access_policies.roles_ids.v1.0](dts/func/access_policies/roles_ids.raml#11-41)|Type|Returns the list of role ids based on the requested user's access policies.|
|[cti.a.p.dts.func.v1.0~a.p.gql.count_tenant_clients.v0.1](gql/deprecated/func/graphql_v1.raml#5524-5536)|Type|DTS function wrapper for GraphQL v1 method CountTenantClients|
|[cti.a.p.dts.func.v1.0~a.p.gql.create_intention.v0.1](gql/deprecated/func/graphql_v1.raml#6866-6878)|Type|DTS function wrapper for GraphQL v1 method CreateIntention|
|[cti.a.p.dts.func.v1.0~a.p.gql.fetch_cred_from_cred_store.v0.1](gql/deprecated/func/graphql_v1.raml#6173-6185)|Type|DTS function wrapper for GraphQL v1 method FetchCredFromCredStore|
|[cti.a.p.dts.func.v1.0~a.p.gql.fetch_items_from_local_cache.v0.1](gql/deprecated/func/graphql_v1.raml#6157-6172)|Type|DTS function wrapper for GraphQL v1 method FetchItemsFromLocalCache|
|[cti.a.p.dts.func.v1.0~a.p.gql.fetch_tenant_creds_from_cred_store.v0.1](gql/deprecated/func/graphql_v1.raml#6186-6198)|Type|DTS function wrapper for GraphQL v1 method FetchTenantCredsFromCredStore|
|[cti.a.p.dts.func.v1.0~a.p.gql.get_a_w_s_limited_credentials.v0.1](gql/deprecated/func/graphql_v1.raml#5914-5926)|Type|DTS function wrapper for GraphQL v1 method GetAWSLimitedCredentials|
|[cti.a.p.dts.func.v1.0~a.p.gql.get_account_keys.v0.1](gql/deprecated/func/graphql_v1.raml#6053-6065)|Type|DTS function wrapper for GraphQL v1 method GetAccountKeys|
|[cti.a.p.dts.func.v1.0~a.p.gql.get_activity.v0.1](gql/deprecated/func/graphql_v1.raml#7050-7062)|Type|DTS function wrapper for GraphQL v1 method GetActivity|
|[cti.a.p.dts.func.v1.0~a.p.gql.get_activity_status.v0.1](gql/deprecated/func/graphql_v1.raml#6290-6302)|Type|DTS function wrapper for GraphQL v1 method GetActivityStatus|
|[cti.a.p.dts.func.v1.0~a.p.gql.get_advanced_automation_static_form_data.v0.1](gql/deprecated/func/graphql_v1.raml#5706-5718)|Type|DTS function wrapper for GraphQL v1 method GetAdvancedAutomationStaticFormData|
|[cti.a.p.dts.func.v1.0~a.p.gql.get_advanced_automation_status.v0.1](gql/deprecated/func/graphql_v1.raml#5693-5705)|Type|DTS function wrapper for GraphQL v1 method GetAdvancedAutomationStatus|
|[cti.a.p.dts.func.v1.0~a.p.gql.get_agent.v0.1](gql/deprecated/func/graphql_v1.raml#5719-5731)|Type|DTS function wrapper for GraphQL v1 method GetAgent|
|[cti.a.p.dts.func.v1.0~a.p.gql.get_alert_presentation.v0.1](gql/deprecated/func/graphql_v1.raml#5771-5783)|Type|DTS function wrapper for GraphQL v1 method GetAlertPresentation|
|[cti.a.p.dts.func.v1.0~a.p.gql.get_alert_types.v0.1](gql/deprecated/func/graphql_v1.raml#5810-5822)|Type|DTS function wrapper for GraphQL v1 method GetAlertTypes|
|[cti.a.p.dts.func.v1.0~a.p.gql.get_alerts.v0.1](gql/deprecated/func/graphql_v1.raml#5745-5757)|Type|DTS function wrapper for GraphQL v1 method GetAlerts|
|[cti.a.p.dts.func.v1.0~a.p.gql.get_alerts_count.v0.1](gql/deprecated/func/graphql_v1.raml#5823-5835)|Type|DTS function wrapper for GraphQL v1 method GetAlertsCount|
|[cti.a.p.dts.func.v1.0~a.p.gql.get_alerts_presentation.v0.1](gql/deprecated/func/graphql_v1.raml#5758-5770)|Type|DTS function wrapper for GraphQL v1 method GetAlertsPresentation|
|[cti.a.p.dts.func.v1.0~a.p.gql.get_all_alerts_policy.v0.1](gql/deprecated/func/graphql_v1.raml#7141-7153)|Type|DTS function wrapper for GraphQL v1 method GetAllAlertsPolicy|
|[cti.a.p.dts.func.v1.0~a.p.gql.get_all_policy_alert_types.v0.1](gql/deprecated/func/graphql_v1.raml#7180-7192)|Type|DTS function wrapper for GraphQL v1 method GetAllPolicyAlertTypes|
|[cti.a.p.dts.func.v1.0~a.p.gql.get_all_recipients_tree.v0.1](gql/deprecated/func/graphql_v1.raml#7167-7179)|Type|DTS function wrapper for GraphQL v1 method GetAllRecipientsTree|
|[cti.a.p.dts.func.v1.0~a.p.gql.get_application.v0.1](gql/deprecated/func/graphql_v1.raml#6426-6438)|Type|DTS function wrapper for GraphQL v1 method GetApplication|
|[cti.a.p.dts.func.v1.0~a.p.gql.get_application_setting.v0.1](gql/deprecated/func/graphql_v1.raml#5576-5588)|Type|DTS function wrapper for GraphQL v1 method GetApplicationSetting|
|[cti.a.p.dts.func.v1.0~a.p.gql.get_application_settings.v0.1](gql/deprecated/func/graphql_v1.raml#5589-5601)|Type|DTS function wrapper for GraphQL v1 method GetApplicationSettings|
|[cti.a.p.dts.func.v1.0~a.p.gql.get_applications.v0.1](gql/deprecated/func/graphql_v1.raml#5628-5640)|Type|DTS function wrapper for GraphQL v1 method GetApplications|
|[cti.a.p.dts.func.v1.0~a.p.gql.get_archives.v0.1](gql/deprecated/func/graphql_v1.raml#7232-7244)|Type|DTS function wrapper for GraphQL v1 method GetArchives|
|[cti.a.p.dts.func.v1.0~a.p.gql.get_archives_local.v0.1](gql/deprecated/func/graphql_v1.raml#7245-7257)|Type|DTS function wrapper for GraphQL v1 method GetArchivesLocal|
|[cti.a.p.dts.func.v1.0~a.p.gql.get_azure_lockable_resource_i_d.v0.1](gql/deprecated/func/graphql_v1.raml#6079-6091)|Type|DTS function wrapper for GraphQL v1 method GetAzureLockableResourceID|
|[cti.a.p.dts.func.v1.0~a.p.gql.get_azure_subscription.v0.1](gql/deprecated/func/graphql_v1.raml#6118-6130)|Type|DTS function wrapper for GraphQL v1 method GetAzureSubscription|
|[cti.a.p.dts.func.v1.0~a.p.gql.get_azure_token.v0.1](gql/deprecated/func/graphql_v1.raml#6131-6143)|Type|DTS function wrapper for GraphQL v1 method GetAzureToken|
|[cti.a.p.dts.func.v1.0~a.p.gql.get_backup.v0.1](gql/deprecated/func/graphql_v1.raml#7323-7335)|Type|DTS function wrapper for GraphQL v1 method GetBackup|
|[cti.a.p.dts.func.v1.0~a.p.gql.get_backups.v0.1](gql/deprecated/func/graphql_v1.raml#7258-7270)|Type|DTS function wrapper for GraphQL v1 method GetBackups|
|[cti.a.p.dts.func.v1.0~a.p.gql.get_client.v0.1](gql/deprecated/func/graphql_v1.raml#5667-5679)|Type|DTS function wrapper for GraphQL v1 method GetClient|
|[cti.a.p.dts.func.v1.0~a.p.gql.get_connection.v0.1](gql/deprecated/func/graphql_v1.raml#6144-6156)|Type|DTS function wrapper for GraphQL v1 method GetConnection|
|[cti.a.p.dts.func.v1.0~a.p.gql.get_container_name.v0.1](gql/deprecated/func/graphql_v1.raml#6066-6078)|Type|DTS function wrapper for GraphQL v1 method GetContainerName|
|[cti.a.p.dts.func.v1.0~a.p.gql.get_container_properties.v0.1](gql/deprecated/func/graphql_v1.raml#6105-6117)|Type|DTS function wrapper for GraphQL v1 method GetContainerProperties|
|[cti.a.p.dts.func.v1.0~a.p.gql.get_cti_metadata.v0.1](gql/deprecated/func/graphql_v1.raml#5875-5887)|Type|DTS function wrapper for GraphQL v1 method GetCtiMetadata|
|[cti.a.p.dts.func.v1.0~a.p.gql.get_cti_new_menu.v0.1](gql/deprecated/func/graphql_v1.raml#7219-7231)|Type|DTS function wrapper for GraphQL v1 method GetCtiNewMenu|
|[cti.a.p.dts.func.v1.0~a.p.gql.get_current_dc.v0.1](gql/deprecated/func/graphql_v1.raml#6400-6412)|Type|DTS function wrapper for GraphQL v1 method GetCurrentDc|
|[cti.a.p.dts.func.v1.0~a.p.gql.get_demo_example.v0.1](gql/deprecated/func/graphql_v1.raml#6199-6211)|Type|DTS function wrapper for GraphQL v1 method GetDemoExample|
|[cti.a.p.dts.func.v1.0~a.p.gql.get_device_sense_customer_summary.v0.1](gql/deprecated/func/graphql_v1.raml#6225-6237)|Type|DTS function wrapper for GraphQL v1 method GetDeviceSenseCustomerSummary|
|[cti.a.p.dts.func.v1.0~a.p.gql.get_device_sense_partner_summary.v0.1](gql/deprecated/func/graphql_v1.raml#6212-6224)|Type|DTS function wrapper for GraphQL v1 method GetDeviceSensePartnerSummary|
|[cti.a.p.dts.func.v1.0~a.p.gql.get_device_sense_summary_tenant_list.v0.1](gql/deprecated/func/graphql_v1.raml#6238-6250)|Type|DTS function wrapper for GraphQL v1 method GetDeviceSenseSummaryTenantList|
|[cti.a.p.dts.func.v1.0~a.p.gql.get_dictionaries.v0.1](gql/deprecated/func/graphql_v1.raml#6737-6752)|Type|DTS function wrapper for GraphQL v1 method GetDictionaries|
|[cti.a.p.dts.func.v1.0~a.p.gql.get_dictionary.v0.1](gql/deprecated/func/graphql_v1.raml#6753-6765)|Type|DTS function wrapper for GraphQL v1 method GetDictionary|
|[cti.a.p.dts.func.v1.0~a.p.gql.get_dictionary_version.v0.1](gql/deprecated/func/graphql_v1.raml#6766-6778)|Type|DTS function wrapper for GraphQL v1 method GetDictionaryVersion|
|[cti.a.p.dts.func.v1.0~a.p.gql.get_dictionary_versions.v0.1](gql/deprecated/func/graphql_v1.raml#6779-6794)|Type|DTS function wrapper for GraphQL v1 method GetDictionaryVersions|
|[cti.a.p.dts.func.v1.0~a.p.gql.get_dispatcher_job.v0.1](gql/deprecated/func/graphql_v1.raml#6361-6373)|Type|DTS function wrapper for GraphQL v1 method GetDispatcherJob|
|[cti.a.p.dts.func.v1.0~a.p.gql.get_display_object.v0.1](gql/deprecated/func/graphql_v1.raml#6824-6836)|Type|DTS function wrapper for GraphQL v1 method GetDisplayObject|
|[cti.a.p.dts.func.v1.0~a.p.gql.get_display_object_version.v0.1](gql/deprecated/func/graphql_v1.raml#6853-6865)|Type|DTS function wrapper for GraphQL v1 method GetDisplayObjectVersion|
|[cti.a.p.dts.func.v1.0~a.p.gql.get_display_object_versions.v0.1](gql/deprecated/func/graphql_v1.raml#6837-6852)|Type|DTS function wrapper for GraphQL v1 method GetDisplayObjectVersions|
|[cti.a.p.dts.func.v1.0~a.p.gql.get_display_objects.v0.1](gql/deprecated/func/graphql_v1.raml#6808-6823)|Type|DTS function wrapper for GraphQL v1 method GetDisplayObjects|
|[cti.a.p.dts.func.v1.0~a.p.gql.get_dynamic_access_policies.v0.1](gql/deprecated/func/graphql_v1.raml#6374-6386)|Type|DTS function wrapper for GraphQL v1 method GetDynamicAccessPolicies|
|[cti.a.p.dts.func.v1.0~a.p.gql.get_e_p_m_resource.v0.1](gql/deprecated/func/graphql_v1.raml#6303-6318)|Type|DTS function wrapper for GraphQL v1 method GetEPMResource|
|[cti.a.p.dts.func.v1.0~a.p.gql.get_events.v0.1](gql/deprecated/func/graphql_v1.raml#6348-6360)|Type|DTS function wrapper for GraphQL v1 method GetEvents|
|[cti.a.p.dts.func.v1.0~a.p.gql.get_gateway_session.v0.1](gql/deprecated/func/graphql_v1.raml#5862-5874)|Type|DTS function wrapper for GraphQL v1 method GetGatewaySession|
|[cti.a.p.dts.func.v1.0~a.p.gql.get_global_key_value.v0.1](gql/deprecated/func/graphql_v1.raml#6387-6399)|Type|DTS function wrapper for GraphQL v1 method GetGlobalKeyValue|
|[cti.a.p.dts.func.v1.0~a.p.gql.get_in_product_notifications.v0.1](gql/deprecated/func/graphql_v1.raml#7193-7205)|Type|DTS function wrapper for GraphQL v1 method GetInProductNotifications|
|[cti.a.p.dts.func.v1.0~a.p.gql.get_integration_settings.v0.1](gql/deprecated/func/graphql_v1.raml#6478-6490)|Type|DTS function wrapper for GraphQL v1 method GetIntegrationSettings|
|[cti.a.p.dts.func.v1.0~a.p.gql.get_integrations_status.v0.1](gql/deprecated/func/graphql_v1.raml#6465-6477)|Type|DTS function wrapper for GraphQL v1 method GetIntegrationsStatus|
|[cti.a.p.dts.func.v1.0~a.p.gql.get_items.v0.1](gql/deprecated/func/graphql_v1.raml#6251-6263)|Type|DTS function wrapper for GraphQL v1 method GetItems|
|[cti.a.p.dts.func.v1.0~a.p.gql.get_lockable_resource_i_d.v0.1](gql/deprecated/func/graphql_v1.raml#5927-5939)|Type|DTS function wrapper for GraphQL v1 method GetLockableResourceID|
|[cti.a.p.dts.func.v1.0~a.p.gql.get_m_f_a_status_info.v0.1](gql/deprecated/func/graphql_v1.raml#5430-5442)|Type|DTS function wrapper for GraphQL v1 method GetMFAStatusInfo|
|[cti.a.p.dts.func.v1.0~a.p.gql.get_monitor_alerts_instance.v0.1](gql/deprecated/func/graphql_v1.raml#7102-7114)|Type|DTS function wrapper for GraphQL v1 method GetMonitorAlertsInstance|
|[cti.a.p.dts.func.v1.0~a.p.gql.get_monitoring_status.v0.1](gql/deprecated/func/graphql_v1.raml#5836-5848)|Type|DTS function wrapper for GraphQL v1 method GetMonitoringStatus|
|[cti.a.p.dts.func.v1.0~a.p.gql.get_monitors_instance.v0.1](gql/deprecated/func/graphql_v1.raml#7089-7101)|Type|DTS function wrapper for GraphQL v1 method GetMonitorsInstance|
|[cti.a.p.dts.func.v1.0~a.p.gql.get_namespaces.v0.1](gql/deprecated/func/graphql_v1.raml#6892-6907)|Type|DTS function wrapper for GraphQL v1 method GetNamespaces|
|[cti.a.p.dts.func.v1.0~a.p.gql.get_nav_menu.v0.1](gql/deprecated/func/graphql_v1.raml#7076-7088)|Type|DTS function wrapper for GraphQL v1 method GetNavMenu|
|[cti.a.p.dts.func.v1.0~a.p.gql.get_new_menu.v0.1](gql/deprecated/func/graphql_v1.raml#7206-7218)|Type|DTS function wrapper for GraphQL v1 method GetNewMenu|
|[cti.a.p.dts.func.v1.0~a.p.gql.get_notification_policies.v0.1](gql/deprecated/func/graphql_v1.raml#6491-6503)|Type|DTS function wrapper for GraphQL v1 method GetNotificationPolicies|
|[cti.a.p.dts.func.v1.0~a.p.gql.get_notification_policy.v0.1](gql/deprecated/func/graphql_v1.raml#6504-6516)|Type|DTS function wrapper for GraphQL v1 method GetNotificationPolicy|
|[cti.a.p.dts.func.v1.0~a.p.gql.get_notification_policy_subscriber.v0.1](gql/deprecated/func/graphql_v1.raml#6517-6529)|Type|DTS function wrapper for GraphQL v1 method GetNotificationPolicySubscriber|
|[cti.a.p.dts.func.v1.0~a.p.gql.get_notification_type_for_tenant.v0.1](gql/deprecated/func/graphql_v1.raml#6562-6574)|Type|DTS function wrapper for GraphQL v1 method GetNotificationTypeForTenant|
|[cti.a.p.dts.func.v1.0~a.p.gql.get_notification_type_with_subscription.v0.1](gql/deprecated/func/graphql_v1.raml#6530-6545)|Type|DTS function wrapper for GraphQL v1 method GetNotificationTypeWithSubscription|
|[cti.a.p.dts.func.v1.0~a.p.gql.get_notification_types.v0.1](gql/deprecated/func/graphql_v1.raml#6546-6561)|Type|DTS function wrapper for GraphQL v1 method GetNotificationTypes|
|[cti.a.p.dts.func.v1.0~a.p.gql.get_package.v0.1](gql/deprecated/func/graphql_v1.raml#6940-6952)|Type|DTS function wrapper for GraphQL v1 method GetPackage|
|[cti.a.p.dts.func.v1.0~a.p.gql.get_packages.v0.1](gql/deprecated/func/graphql_v1.raml#6966-6978)|Type|DTS function wrapper for GraphQL v1 method GetPackages|
|[cti.a.p.dts.func.v1.0~a.p.gql.get_plan.v0.1](gql/deprecated/func/graphql_v1.raml#5849-5861)|Type|DTS function wrapper for GraphQL v1 method GetPlan|
|[cti.a.p.dts.func.v1.0~a.p.gql.get_policies_count.v0.1](gql/deprecated/func/graphql_v1.raml#5417-5429)|Type|DTS function wrapper for GraphQL v1 method GetPoliciesCount|
|[cti.a.p.dts.func.v1.0~a.p.gql.get_policy.v0.1](gql/deprecated/func/graphql_v1.raml#6413-6425)|Type|DTS function wrapper for GraphQL v1 method GetPolicy|
|[cti.a.p.dts.func.v1.0~a.p.gql.get_policy_with_i_d.v0.1](gql/deprecated/func/graphql_v1.raml#6439-6451)|Type|DTS function wrapper for GraphQL v1 method GetPolicyWithID|
|[cti.a.p.dts.func.v1.0~a.p.gql.get_pool.v0.1](gql/deprecated/func/graphql_v1.raml#6992-7004)|Type|DTS function wrapper for GraphQL v1 method GetPool|
|[cti.a.p.dts.func.v1.0~a.p.gql.get_pools.v0.1](gql/deprecated/func/graphql_v1.raml#7005-7020)|Type|DTS function wrapper for GraphQL v1 method GetPools|
|[cti.a.p.dts.func.v1.0~a.p.gql.get_presentation.v0.1](gql/deprecated/func/graphql_v1.raml#6653-6665)|Type|DTS function wrapper for GraphQL v1 method GetPresentation|
|[cti.a.p.dts.func.v1.0~a.p.gql.get_presentation_by_priority.v0.1](gql/deprecated/func/graphql_v1.raml#6588-6600)|Type|DTS function wrapper for GraphQL v1 method GetPresentationByPriority|
|[cti.a.p.dts.func.v1.0~a.p.gql.get_presentations.v0.1](gql/deprecated/func/graphql_v1.raml#6627-6639)|Type|DTS function wrapper for GraphQL v1 method GetPresentations|
|[cti.a.p.dts.func.v1.0~a.p.gql.get_presentations_by_brand_i_d.v0.1](gql/deprecated/func/graphql_v1.raml#6640-6652)|Type|DTS function wrapper for GraphQL v1 method GetPresentationsByBrandID|
|[cti.a.p.dts.func.v1.0~a.p.gql.get_presentations_public.v0.1](gql/deprecated/func/graphql_v1.raml#6601-6613)|Type|DTS function wrapper for GraphQL v1 method GetPresentationsPublic|
|[cti.a.p.dts.func.v1.0~a.p.gql.get_presentations_public_cors.v0.1](gql/deprecated/func/graphql_v1.raml#6614-6626)|Type|DTS function wrapper for GraphQL v1 method GetPresentationsPublicCors|
|[cti.a.p.dts.func.v1.0~a.p.gql.get_processes.v0.1](gql/deprecated/func/graphql_v1.raml#6264-6276)|Type|DTS function wrapper for GraphQL v1 method GetProcesses|
|[cti.a.p.dts.func.v1.0~a.p.gql.get_profile.v0.1](gql/deprecated/func/graphql_v1.raml#5680-5692)|Type|DTS function wrapper for GraphQL v1 method GetProfile|
|[cti.a.p.dts.func.v1.0~a.p.gql.get_protection_plan.v0.1](gql/deprecated/func/graphql_v1.raml#5732-5744)|Type|DTS function wrapper for GraphQL v1 method GetProtectionPlan|
|[cti.a.p.dts.func.v1.0~a.p.gql.get_qualitative_data.v0.1](gql/deprecated/func/graphql_v1.raml#6332-6347)|Type|DTS function wrapper for GraphQL v1 method GetQualitativeData|
|[cti.a.p.dts.func.v1.0~a.p.gql.get_resource.v0.1](gql/deprecated/func/graphql_v1.raml#6452-6464)|Type|DTS function wrapper for GraphQL v1 method GetResource|
|[cti.a.p.dts.func.v1.0~a.p.gql.get_rollback_statistics.v0.1](gql/deprecated/func/graphql_v1.raml#6277-6289)|Type|DTS function wrapper for GraphQL v1 method GetRollbackStatistics|
|[cti.a.p.dts.func.v1.0~a.p.gql.get_s3_asset.v0.1](gql/deprecated/func/graphql_v1.raml#6575-6587)|Type|DTS function wrapper for GraphQL v1 method GetS3Asset|
|[cti.a.p.dts.func.v1.0~a.p.gql.get_script_by_repository_and_guid.v0.1](gql/deprecated/func/graphql_v1.raml#6879-6891)|Type|DTS function wrapper for GraphQL v1 method GetScriptByRepositoryAndGuid|
|[cti.a.p.dts.func.v1.0~a.p.gql.get_setting_values.v0.1](gql/deprecated/func/graphql_v1.raml#6924-6939)|Type|DTS function wrapper for GraphQL v1 method GetSettingValues|
|[cti.a.p.dts.func.v1.0~a.p.gql.get_settings.v0.1](gql/deprecated/func/graphql_v1.raml#6908-6923)|Type|DTS function wrapper for GraphQL v1 method GetSettings|
|[cti.a.p.dts.func.v1.0~a.p.gql.get_software.v0.1](gql/deprecated/func/graphql_v1.raml#6953-6965)|Type|DTS function wrapper for GraphQL v1 method GetSoftware|
|[cti.a.p.dts.func.v1.0~a.p.gql.get_softwares.v0.1](gql/deprecated/func/graphql_v1.raml#6979-6991)|Type|DTS function wrapper for GraphQL v1 method GetSoftwares|
|[cti.a.p.dts.func.v1.0~a.p.gql.get_status.v0.1](gql/deprecated/func/graphql_v1.raml#5784-5796)|Type|DTS function wrapper for GraphQL v1 method GetStatus|
|[cti.a.p.dts.func.v1.0~a.p.gql.get_status_presentation.v0.1](gql/deprecated/func/graphql_v1.raml#5797-5809)|Type|DTS function wrapper for GraphQL v1 method GetStatusPresentation|
|[cti.a.p.dts.func.v1.0~a.p.gql.get_storage_accounts.v0.1](gql/deprecated/func/graphql_v1.raml#5966-5981)|Type|DTS function wrapper for GraphQL v1 method GetStorageAccounts|
|[cti.a.p.dts.func.v1.0~a.p.gql.get_subscribed_alerts_policies.v0.1](gql/deprecated/func/graphql_v1.raml#7115-7127)|Type|DTS function wrapper for GraphQL v1 method GetSubscribedAlertsPolicies|
|[cti.a.p.dts.func.v1.0~a.p.gql.get_subscribed_recipients_flat.v0.1](gql/deprecated/func/graphql_v1.raml#7154-7166)|Type|DTS function wrapper for GraphQL v1 method GetSubscribedRecipientsFlat|
|[cti.a.p.dts.func.v1.0~a.p.gql.get_subscribed_recipients_tree.v0.1](gql/deprecated/func/graphql_v1.raml#7128-7140)|Type|DTS function wrapper for GraphQL v1 method GetSubscribedRecipientsTree|
|[cti.a.p.dts.func.v1.0~a.p.gql.get_task.v0.1](gql/deprecated/func/graphql_v1.raml#7021-7033)|Type|DTS function wrapper for GraphQL v1 method GetTask|
|[cti.a.p.dts.func.v1.0~a.p.gql.get_tasks.v0.1](gql/deprecated/func/graphql_v1.raml#7034-7049)|Type|DTS function wrapper for GraphQL v1 method GetTasks|
|[cti.a.p.dts.func.v1.0~a.p.gql.get_template.v0.1](gql/deprecated/func/graphql_v1.raml#6682-6694)|Type|DTS function wrapper for GraphQL v1 method GetTemplate|
|[cti.a.p.dts.func.v1.0~a.p.gql.get_template_by_priority.v0.1](gql/deprecated/func/graphql_v1.raml#6695-6707)|Type|DTS function wrapper for GraphQL v1 method GetTemplateByPriority|
|[cti.a.p.dts.func.v1.0~a.p.gql.get_template_translation.v0.1](gql/deprecated/func/graphql_v1.raml#6795-6807)|Type|DTS function wrapper for GraphQL v1 method GetTemplateTranslation|
|[cti.a.p.dts.func.v1.0~a.p.gql.get_template_version.v0.1](gql/deprecated/func/graphql_v1.raml#6724-6736)|Type|DTS function wrapper for GraphQL v1 method GetTemplateVersion|
|[cti.a.p.dts.func.v1.0~a.p.gql.get_template_versions.v0.1](gql/deprecated/func/graphql_v1.raml#6708-6723)|Type|DTS function wrapper for GraphQL v1 method GetTemplateVersions|
|[cti.a.p.dts.func.v1.0~a.p.gql.get_templates.v0.1](gql/deprecated/func/graphql_v1.raml#6666-6681)|Type|DTS function wrapper for GraphQL v1 method GetTemplates|
|[cti.a.p.dts.func.v1.0~a.p.gql.get_tenant.v0.1](gql/deprecated/func/graphql_v1.raml#5495-5507)|Type|DTS function wrapper for GraphQL v1 method GetTenant|
|[cti.a.p.dts.func.v1.0~a.p.gql.get_tenant_ancestry.v0.1](gql/deprecated/func/graphql_v1.raml#5508-5523)|Type|DTS function wrapper for GraphQL v1 method GetTenantAncestry|
|[cti.a.p.dts.func.v1.0~a.p.gql.get_tenant_applications.v0.1](gql/deprecated/func/graphql_v1.raml#5602-5614)|Type|DTS function wrapper for GraphQL v1 method GetTenantApplications|
|[cti.a.p.dts.func.v1.0~a.p.gql.get_tenant_brand.v0.1](gql/deprecated/func/graphql_v1.raml#5563-5575)|Type|DTS function wrapper for GraphQL v1 method GetTenantBrand|
|[cti.a.p.dts.func.v1.0~a.p.gql.get_tenant_group.v0.1](gql/deprecated/func/graphql_v1.raml#5443-5455)|Type|DTS function wrapper for GraphQL v1 method GetTenantGroup|
|[cti.a.p.dts.func.v1.0~a.p.gql.get_tenant_offering_items.v0.1](gql/deprecated/func/graphql_v1.raml#5550-5562)|Type|DTS function wrapper for GraphQL v1 method GetTenantOfferingItems|
|[cti.a.p.dts.func.v1.0~a.p.gql.get_tenant_tree.v0.1](gql/deprecated/func/graphql_v1.raml#7063-7075)|Type|DTS function wrapper for GraphQL v1 method GetTenantTree|
|[cti.a.p.dts.func.v1.0~a.p.gql.get_tenant_users.v0.1](gql/deprecated/func/graphql_v1.raml#5641-5653)|Type|DTS function wrapper for GraphQL v1 method GetTenantUsers|
|[cti.a.p.dts.func.v1.0~a.p.gql.get_tenants.v0.1](gql/deprecated/func/graphql_v1.raml#5537-5549)|Type|DTS function wrapper for GraphQL v1 method GetTenants|
|[cti.a.p.dts.func.v1.0~a.p.gql.get_time_series.v0.1](gql/deprecated/func/graphql_v1.raml#6319-6331)|Type|DTS function wrapper for GraphQL v1 method GetTimeSeries|
|[cti.a.p.dts.func.v1.0~a.p.gql.get_user.v0.1](gql/deprecated/func/graphql_v1.raml#5469-5481)|Type|DTS function wrapper for GraphQL v1 method GetUser|
|[cti.a.p.dts.func.v1.0~a.p.gql.get_user_access_policies.v0.1](gql/deprecated/func/graphql_v1.raml#5482-5494)|Type|DTS function wrapper for GraphQL v1 method GetUserAccessPolicies|
|[cti.a.p.dts.func.v1.0~a.p.gql.get_users.v0.1](gql/deprecated/func/graphql_v1.raml#5456-5468)|Type|DTS function wrapper for GraphQL v1 method GetUsers|
|[cti.a.p.dts.func.v1.0~a.p.gql.get_vault.v0.1](gql/deprecated/func/graphql_v1.raml#7297-7309)|Type|DTS function wrapper for GraphQL v1 method GetVault|
|[cti.a.p.dts.func.v1.0~a.p.gql.get_vault_archives.v0.1](gql/deprecated/func/graphql_v1.raml#7310-7322)|Type|DTS function wrapper for GraphQL v1 method GetVaultArchives|
|[cti.a.p.dts.func.v1.0~a.p.gql.get_vault_manager_dynamic_access_policies_by_subject.v0.1](gql/deprecated/func/graphql_v1.raml#7349-7361)|Type|DTS function wrapper for GraphQL v1 method GetVaultManagerDynamicAccessPoliciesBySubject|
|[cti.a.p.dts.func.v1.0~a.p.gql.get_vaults.v0.1](gql/deprecated/func/graphql_v1.raml#7271-7283)|Type|DTS function wrapper for GraphQL v1 method GetVaults|
|[cti.a.p.dts.func.v1.0~a.p.gql.get_vaults_local.v0.1](gql/deprecated/func/graphql_v1.raml#7284-7296)|Type|DTS function wrapper for GraphQL v1 method GetVaultsLocal|
|[cti.a.p.dts.func.v1.0~a.p.gql.get_workflow_job.v0.1](gql/deprecated/func/graphql_v1.raml#7362-7374)|Type|DTS function wrapper for GraphQL v1 method GetWorkflowJob|
|[cti.a.p.dts.func.v1.0~a.p.gql.issue_account_s_a_s_token.v0.1](gql/deprecated/func/graphql_v1.raml#6040-6052)|Type|DTS function wrapper for GraphQL v1 method IssueAccountSASToken|
|[cti.a.p.dts.func.v1.0~a.p.gql.issue_s_a_s_token.v0.1](gql/deprecated/func/graphql_v1.raml#5982-5994)|Type|DTS function wrapper for GraphQL v1 method IssueSASToken|
|[cti.a.p.dts.func.v1.0~a.p.gql.list_azure_vaults.v0.1](gql/deprecated/func/graphql_v1.raml#6024-6039)|Type|DTS function wrapper for GraphQL v1 method ListAzureVaults|
|[cti.a.p.dts.func.v1.0~a.p.gql.list_buckets.v0.1](gql/deprecated/func/graphql_v1.raml#5888-5900)|Type|DTS function wrapper for GraphQL v1 method ListBuckets|
|[cti.a.p.dts.func.v1.0~a.p.gql.list_containers.v0.1](gql/deprecated/func/graphql_v1.raml#6008-6023)|Type|DTS function wrapper for GraphQL v1 method ListContainers|
|[cti.a.p.dts.func.v1.0~a.p.gql.parse_microsoft_azure_u_r_i.v0.1](gql/deprecated/func/graphql_v1.raml#6092-6104)|Type|DTS function wrapper for GraphQL v1 method ParseMicrosoftAzureURI|
|[cti.a.p.dts.func.v1.0~a.p.gql.resolve_tenants_i_ds.v0.1](gql/deprecated/func/graphql_v1.raml#5615-5627)|Type|DTS function wrapper for GraphQL v1 method ResolveTenantsIDs|
|[cti.a.p.dts.func.v1.0~a.p.gql.search_license_and_account.v0.1](gql/deprecated/func/graphql_v1.raml#5654-5666)|Type|DTS function wrapper for GraphQL v1 method SearchLicenseAndAccount|
|[cti.a.p.dts.func.v1.0~a.p.gql.set_container_metadata.v0.1](gql/deprecated/func/graphql_v1.raml#5995-6007)|Type|DTS function wrapper for GraphQL v1 method SetContainerMetadata|
|[cti.a.p.dts.func.v1.0~a.p.gql.validate_and_normalize_endpoint.v0.1](gql/deprecated/func/graphql_v1.raml#5953-5965)|Type|DTS function wrapper for GraphQL v1 method ValidateAndNormalizeEndpoint|
|[cti.a.p.dts.func.v1.0~a.p.gql.validate_credentials.v0.1](gql/deprecated/func/graphql_v1.raml#5901-5913)|Type|DTS function wrapper for GraphQL v1 method ValidateCredentials|
|[cti.a.p.dts.func.v1.0~a.p.gql.verify_tenant_access.v0.1](gql/deprecated/func/graphql_v1.raml#7336-7348)|Type|DTS function wrapper for GraphQL v1 method VerifyTenantAccess|
|[cti.a.p.dts.func.v1.0~a.p.gql.wasabi_endpoint_to_region.v0.1](gql/deprecated/func/graphql_v1.raml#5940-5952)|Type|DTS function wrapper for GraphQL v1 method WasabiEndpointToRegion|
|[cti.a.p.dts.func.v1.0~a.p.group.capabilities._names_.has.v1.0](dts/func/group/capabilities/_names_/has.raml#11-47)|Type|Checks if the group of requested tenant has all the specified capabilities by applying bitmask comparison|
|[cti.a.p.dts.func.v1.0~a.p.group.capabilities.branding.has.v1.0](dts/func/group/capabilities/branding/has.raml#11-26)|Type|Checks if the group of requested tenant has all the specified capabilities by applying bitmask comparison|
|[cti.a.p.dts.func.v1.0~a.p.legacy_app._type_.setting._name_.effective.value.truthy.v1.0](dts/func/legacy_app/_type_/setting/_name_/effective/value/truthy.raml#12-41)|Type|Checks whether legacy application setting effective value for a given tenant is truthy|
|[cti.a.p.dts.func.v1.0~a.p.legacy_app._type_.setting._name_.effective.value.v1.0](dts/func/legacy_app/_type_/setting/_name_/effective/value.raml#12-46)|Type|Legacy application setting effective value for a given tenant|
|[cti.a.p.dts.func.v1.0~a.p.legacy_app._type_.setting._name_.own.value.v1.0](dts/func/legacy_app/_type_/setting/_name_/own/value.raml#12-46)|Type|Legacy application setting own value for a given tenant|
|[cti.a.p.dts.func.v1.0~a.p.legacy_app.platform.setting._name_.effective.value.truthy.v1.0](dts/func/legacy_app/platform/setting/_name_/effective/value/truthy.raml#12-35)|Type|Checks whether platform legacy application setting effective value for a given tenant is truthy|
|[cti.a.p.dts.func.v1.0~a.p.legacy_app.platform.setting._name_.own.value.v1.0](dts/func/legacy_app/platform/setting/_name_/own/value.raml#12-36)|Type|Returns the platform legacy application setting own value for a given tenant|
|[cti.a.p.dts.func.v1.0~a.p.legacy_setting._domain_._namespace_._id_.v1.0](dts/func/legacy_setting/_domain_/_namespace_/_id_.raml#11-71)|Type|Returns the corresponding setting value object of the requested tenant|
|[cti.a.p.dts.func.v1.0~a.p.legacy_setting.storage._namespace_._id_.v1.0](dts/func/legacy_setting/storage/_namespace_/_id_.raml#11-37)|Type|Returns the corresponding STORAGE Domain setting value object of the requested tenant|
|[cti.a.p.dts.func.v1.0~a.p.legacy_setting.tenant._namespace_._id_.v1.0](dts/func/legacy_setting/tenant/_namespace_/_id_.raml#11-49)|Type|Returns the corresponding TENANT Domain setting value object of the requested tenant|
|[cti.a.p.dts.func.v1.0~a.p.legacy_setting.tenant.com_acronis_abgw_geo_redundancy._id_.v1.0](dts/func/legacy_setting/tenant/com_acronis_abgw_geo_redundancy/_id_.raml#11-36)|Type|Returns the corresponding setting value object of the requested tenant in com_acronis_abgw_geo_redundancy namespace of TENANT Domain|
|[cti.a.p.dts.func.v1.0~a.p.legacy_setting.tenant.com_acronis_customer_portal._id_.v1.0](dts/func/legacy_setting/tenant/com_acronis_customer_portal/_id_.raml#11-36)|Type|Returns the corresponding TENANT Domain setting value object of the requested tenant|
|[cti.a.p.dts.func.v1.0~a.p.legacy_setting.tenant.com_acronis_customer_portal.beta.v1.0](dts/func/legacy_setting/tenant/com_acronis_customer_portal/beta_enabled.raml#11-33)|Type|Returns the customer_info setting value of the requested tenant|
|[cti.a.p.dts.func.v1.0~a.p.legacy_setting.tenant.com_acronis_customers._id_.v1.0](dts/func/legacy_setting/tenant/com_acronis_customer/_id_.raml#11-38)|Type|Returns the corresponding TENANT Domain setting value object of the requested tenant|
|[cti.a.p.dts.func.v1.0~a.p.legacy_setting.tenant.com_acronis_customers.customer_info.v1.0](dts/func/legacy_setting/tenant/com_acronis_customer/customer_info.raml#11-33)|Type|Returns the customer_info setting value of the requested tenant|
|[cti.a.p.dts.func.v1.0~a.p.legacy_setting.tenant.com_acronis_partners_company._id_.v1.0](dts/func/legacy_setting/tenant/com_acronis_partners_company/_id_.raml#11-38)|Type|Returns the corresponding TENANT Domain setting value object of the requested tenant|
|[cti.a.p.dts.func.v1.0~a.p.legacy_setting.tenant.com_acronis_partners_company.partner_expiration_date.v1.0](dts/func/legacy_setting/tenant/com_acronis_partners_company/partner_expiration_date.raml#11-33)|Type|Returns the partner_expiration_date setting value of the requested tenant|
|[cti.a.p.dts.func.v1.0~a.p.legacy_setting.tenant.com_acronis_partners_company.partner_setting.v1.0](dts/func/legacy_setting/tenant/com_acronis_partners_company/partner_setting.raml#11-33)|Type|Returns the partner_setting setting value of the requested tenant|
|[cti.a.p.dts.func.v1.0~a.p.oagw.service_discovery_parser.v1.0](oagw/upstream_v1.0.raml#105-120)|Type|interface of function which OAGW uses to parse a response received from Upstream.service_discovery_url|
|[cti.a.p.dts.func.v1.0~a.p.oagw.upstream_constructor.v1.0](oagw/upstream_v1.0.raml#87-104)|Type|creates upstream which is specific for a particular tenant|
|[cti.a.p.dts.func.v1.0~a.p.offering_items._names_.enabled.any_of.v1.0](dts/func/offering_items/_names_/enabled/any_of.raml#11-37)|Type|Checks if requested tenant has any of the speicified offering items enabled|
|[cti.a.p.dts.func.v1.0~a.p.offering_items._names_.enabled_legacy_app._type_.has.v1.0](dts/func/offering_items/_names_/enabled_legacy_app/_type_/has.raml#12-40)|Type|Checks if any offering items under a given legacy app is enabled|
|[cti.a.p.dts.func.v1.0~a.p.offering_items._names_.enabled_legacy_app.backup.has.v1.0](dts/func/offering_items/_names_/enabled_legacy_app/backup/has.raml#11-29)|Type|Checks if requested tenant has Cyber Protection (backup) legacy app|
|[cti.a.p.dts.func.v1.0~a.p.offering_items._names_.legacy_app._type_.has.v1.0](dts/func/offering_items/_names_/legacy_app/_type_/has.raml#12-36)|Type|Checks if a tenant has a certain legacy app|
|[cti.a.p.dts.func.v1.0~a.p.offering_items._names_.legacy_app.backup.has.v1.0](dts/func/offering_items/_names_/legacy_app/backup/has.raml#11-29)|Type|Checks if requested tenant has Cyber Protection (backup) legacy app|
|[cti.a.p.dts.func.v1.0~a.p.tenant.customer_type._names_.is.v1.0](dts/func/tenant/customer_type/is_customer_type.raml#10-34)|Type|Checks if the tenant's customer type equals to the specified customer type.|
|[cti.a.p.dts.func.v1.0~a.p.tenant.is_self.v1.0](dts/func/tenant/is_self.raml#11-27)|Type|Checks if the currently logged-in user belongs to the tenant specified by the given tenant id|
|[cti.a.p.dts.func.v1.0~a.p.tenant.kind._names_.any_of.v1.0](dts/func/tenant/kind/_names_/any_of.raml#11-38)|Type|Checks if the tenant's kind is any of the specified kinds.|
|[cti.a.p.dts.func.v1.0~a.p.tenant.kind._names_.is.v1.0](dts/func/tenant/kind/_names_/is.raml#11-43)|Type|Checks if the tenant's kind equals to the specified kind.|
|[cti.a.p.dts.func.v1.0~a.p.tenant.kind.customer.is.v1.0](dts/func/tenant/kind/customer/is.raml#11-31)|Type|Checks if the tenant's kind is customer|
|[cti.a.p.dts.func.v1.0~a.p.tenant.kind.customer_partner.any_of.v1.0](dts/func/tenant/kind/customer_partner/any_of.raml#11-28)|Type|Checks if the tenant's kind is of customer or partner|
|[cti.a.p.dts.func.v1.0~a.p.tenant.kind.customer_unit.any_of.v1.0](dts/func/tenant/kind/customer_unit/any_of.raml#11-30)|Type|Checks if the tenant's kind is of customer or unit|
|[cti.a.p.dts.func.v1.0~a.p.tenant.kind.partner.is.v1.0](dts/func/tenant/kind/partner/is.raml#11-29)|Type|Checks if the tenant's kind is partner|
|[cti.a.p.dts.func.v1.0~a.p.tenant.kind.root_subroot.any_of.v1.0](dts/func/tenant/kind/root_subroot/any_of.raml#11-29)|Type|Checks if tenant kind is `root`, which implies they are either the root tenant or a subroot tenant|
|[cti.a.p.dts.func.v1.0~a.p.tenant.kind.the_root.is.v1.0](dts/func/tenant/kind/the_root/is.raml#11-33)|Type|Checks if the tenant_id provided belongs to the root tenant|
|[cti.a.p.dts.func.v1.0~a.p.tenant.kind.unit.is.v1.0](dts/func/tenant/kind/unit/is.raml#11-29)|Type|Checks if the tenant's kind is unit|
|[cti.a.p.dts.func.v1.0~a.p.wf.flow.v1.0](wf/types.raml#13-55)|Type|Workflow entities are flows developed using serverless workflow specification v0.7. It uses `cti-traits.source` to provide the serverless workflow code. Refer https://raw.githubusercontent.com/serverlessworkflow/specification/0.7.x/schema/workflow.json for specification details |
|[cti.a.p.dts.module.v0.1](dts/types.raml#507-545)|Type|DTS module represents a set of imperative (GO) functions and their configuration |
|[cti.a.p.dts.processing_step.v1.0](dts/types.raml#235-278)|Type|These are specialized DTS functions that can be appended to regular DTS functions, serving as an extra processing step to be performed on the resulting objects. The concept of the DTS processing pipeline is akin to the rendering pipeline in 3D graphics, where certain pipeline components construct the objects (referred to as functions in our case), while others can modify them (represented by processing steps in DTS and 'shaders' in the 3D graphics pipeline).<br/>The Processing Step function always uses original function `.returns` as input parameter and as the return value type.<br/>Processing Steps are intended to: - (a) filter out the whole object(s) generated by the - (b) update the constructed object fields, e.g. localize the value or change the text<br/>Processing Steps can be attached to multiple functions in order to make massive filtering, e.g. to hide all the UI items generated by given Cyber Application because of licensing or legal/access limitations for given user |
|[cti.a.p.dts.tag.v1.0](dts/types.raml#33-48)|Type|Specific DTS object specifying a reusable tag which can be used to find/group DTS functions or any other objects in value resolvers like $group_ref(tag=...) |

### User Interface

|Name|Kind|Description|
|---|---|---|
|[cti.a.p.ui.toolkit.form.type.v1.0](app/ui_toolkit_forms.raml#57-73)|Type|UI Toolkit form type entities are bound to the UI Toolkit form entities and define the type of the UI Toolkit form. |
|[cti.a.p.ui.toolkit.form.type.v1.0~a.p.connection_setup.v1.0](app/ui_toolkit_forms.raml#77-78)|Instance|Connection setup form (popup + setting view with predefined callback on saving)|
|[cti.a.p.ui.toolkit.form.type.v1.0~a.p.custom.v1.0](app/ui_toolkit_forms.raml#75-76)|Instance|Declares custom form type, e.g. Lastpass users|
|[cti.a.p.ui.toolkit.form.type.v1.0~a.p.customer_mapping.v1.0](app/ui_toolkit_forms.raml#79-80)|Instance|Customer mapping form without customization|
|[cti.a.p.ui.toolkit.form.v1.0](app/ui_toolkit_forms.raml#20-56)|Type|Defines the contents of the form that will be displayed by the UI.|

### Presentation

|Name|Kind|Description|
|---|---|---|
|[cti.a.p.presentation.dict.v1.0](l10n/types.raml#39-65)|Type|Dictionary of localized data|

### License Management

|Name|Kind|Description|
|---|---|---|
|[cti.a.p.lic.edition.v0.1](lic/offering_item.raml#43-58)|Type|An edition can be defined as a specific version or variation of a product or service,  often tailored to meet the needs of a particular target audience or market segment. |
|[cti.a.p.lic.feature.v1.0](lic/feature.raml#15-57)|Type|A single technical capability provided by the Platform or Cyber Application. |
|[cti.a.p.lic.offering_item.v0.1](lic/offering_item.raml#59-90)|Type|An offering item is a set of service features that are grouped by specific workload type or functionality. The combination of offering items determines a tenant's functionality,  which can be adjusted by enabling or disabling individual offering items. |
|[cti.a.p.lic.oi.v0.1](lic/offering_item.raml#59-90)|Type|An offering item is a set of service features that are grouped by specific workload type or functionality. The combination of offering items determines a tenant's functionality,  which can be adjusted by enabling or disabling individual offering items. |
|[cti.a.p.lic.product.v0.1](lic/offering_item.raml#27-42)|Type|It is a marketable and sellable entity  that groups specific offering items by grade of functionality and cost.  |
|[cti.a.p.lic.service.v0.1](lic/offering_item.raml#91-110)|Type|Grouping entity for offering items, shows offering items belonging to one Service (internal or external).  Backup, DR, GreatHorn are services. |
|[cti.a.p.lic.service_plan.v1.0](lic/service_plans.raml#24-47)|Type|A base type for service plan to be applied on tenants.|
|[cti.a.p.lic.usage.v1.0](lic/usage.raml#27-58)|Type|An entity that is used for licensing usage tracking. |

### Outbound API Gateway

|Name|Kind|Description|
|---|---|---|
|[cti.a.p.oagw.authtype.v1.0](oagw/authtype_v1.raml#15-28)|Type|Describes authentication type used by the external service|
|[cti.a.p.oagw.authtype.v1.0~a.p.oagw.apikey.v1.0](oagw/authtype_v1.raml#34-36)|Instance|authentication using api key|
|[cti.a.p.oagw.authtype.v1.0~a.p.oagw.basic.v1.0](oagw/authtype_v1.raml#31-33)|Instance|authentication using username:passward (see RFC 7617)|
|[cti.a.p.oagw.authtype.v1.0~a.p.oagw.oauth20.client_cred.v1.0](oagw/authtype_v1.raml#37-39)|Instance|OAuth 2.0 Client Credentials Grant when credentials for token request are passed in a body ( RFC 6749)|
|[cti.a.p.oagw.authtype.v1.0~a.p.oagw.oauth20.client_cred_basic.v1.0](oagw/authtype_v1.raml#40-42)|Instance|OAuth 2.0 Client Credentials Grant' when credentials for token request are passed according "to Basic" schema ( RFC 6749)|
|[cti.a.p.oagw.authtype.v1.0~a.p.oagw.oauth20.user_cred.v1.0](oagw/authtype_v1.raml#43-44)|Instance|OAuth 2.0 Resource Owner Password Credentials Grant ( RFC 6749)|
|[cti.a.p.oagw.route.v0.1](oagw/route_v0.1.raml#16-57)|Type|Presents details of API route. |
|[cti.a.p.oagw.route.v1.0](oagw/route_v1.0.raml#16-57)|Type|Presents details of API route. |
|[cti.a.p.oagw.upstream.v0.1](oagw/upstream_v0.1.raml#21-78)|Type|Presents an external service which can be requested via OAGW (Outbound API Gateway). |
|[cti.a.p.oagw.upstream.v1.0](oagw/upstream_v1.0.raml#21-86)|Type|Presents an external service which can be requested via OAGW (Outbound API Gateway). |

### Task Manager

|Name|Kind|Description|
|---|---|---|
|[cti.a.p.tm.activity.v1.0](tm/types.raml#449-557)|Type|Defines the structure of the activity that has occurred. |
|[cti.a.p.tm.queue.v1.0](tm/types.raml#219-242)|Type|Task queue is a stream of tasks of the same or different types sharing the same delivery,  ordering, consolidation & retention rules. |
|[cti.a.p.tm.task.v1.0](tm/types.raml#243-448)|Type|Defines the structure of the task that has occurred.<br/>Task will contain two types of information: the task data representing the occurrence and context metadata providing contextual information about the occurrence. A single occurrence may result in more than one task. |

### Other

|Name|Kind|Description|
|---|---|---|
|[cti.a.p.content.v1.0](content/types.raml#8-45)|Type|Defines a base abstract type for handling diverse content across the platform. This type serves as a foundational model for other content-driven types, where each derived type must specify its own data schema. It primarily includes a 'type' field that categorizes the content and a 'data' field whose structure varies depending on the specified type. |
|[cti.a.p.content.v1.0~a.p.md_x.v1.0](content/md_x.raml#8-42)|Type|It supports [CommonMarks markdown format](https://commonmark.org/) and below additional features. * Links can be represented using CTI Call object with below syntax   `[SomeText](#call=<DTS_FUNC_CTI_ID>&<FUNC_PARAM1>&<FUNC_PARAM2>&...)`   e.g. `[**Incident 711** - Not mitigated](#call=cti.a.p.dts.func.v1.0~a.ui.call.interface.v1.0~a.xdr.incident.v1.0&incident_id=711)` |
|[cti.a.p.err.v1.0](err/types.raml#15-116)|Type|The `cti.a.p.err.v1.0` type is a generic purpose error class that can be used in various subsystems and applications such as DTS functions or REST APIs |
|[cti.a.p.err.v1.0~a.p.dts.runtime_error.v1.0](dts/types.raml#103-120)|Type|The `cti.a.p.err.v1.0~a.p.dts.runtime_error.v1.0` error indicates that the serverless runtime encountered an unexpected and unrecoverable runtime error while trying to execute a DTS function or processing step. This error typically happens in cases of malformed CEL expressions, nonexisting value resolvers, syntax errors, etc. The `message` attribute should contain appropriate information explaining the origin of the error. |
|[cti.a.p.err.v1.0~a.p.dts.upstream_error.v1.0](dts/types.raml#49-102)|Type|The `cti.a.p.err.v1.0~a.p.dts.upstream_error.v1.0` error indicates that the serverless runtime encountered an unexpected and unrecoverable error while communicating to an upstream service while trying to execute a DTS function or processing step. This error typically happens if the DTS function or processing step involves a remote call to a service using HTTP, GraphQL, or gRPC protocols. Detailed information regarding the upstream error is captured within the `upstream_error` attribute of the error. |
|[cti.a.p.err.v1.0~a.p.grpc_error.v1.0](err/types.raml#123-128)|Type|A container for gRPC errors. The `code` attribute contains gRPC status code associated with given error. The `action` could reflect exact action e.g. 'connecting to service'|
|[cti.a.p.err.v1.0~a.p.http_error.v1.0](err/types.raml#117-122)|Type|A container for HTTP errors. The `code` attribute contains HTTP status code associated with given error. The `action` could reflect exact method and url, e.g. 'GET /my/api'|
|[cti.a.p.err.v1.0~a.p.linux_error.v1.0](err/types.raml#129-133)|Type|A container for Linux errors. The `code` attribute contains Linux errno code associated with given error. The `action` could reflect exact action e.g. 'connecting to 10.0.0.1'|
|[cti.a.p.status_code.v1.0](status/types.raml#12-38)|Type|A general purpose status code metadata container reflecting some known protocols' statuses or error codes|
|[cti.a.p.status_code.v1.0~a.p.grpc.v1.0](status/grpc.raml#13-19)|Type|gRPC protocol statuses: https://grpc.github.io/grpc/core/md_doc_statuscodes.html|
|[cti.a.p.status_code.v1.0~a.p.grpc.v1.0~a.p.cancelled.1.v1.0](status/grpc.raml#25-28)|Instance|The operation was cancelled, typically by the caller.|
|[cti.a.p.status_code.v1.0~a.p.grpc.v1.0~a.p.invalid_argument.3.v1.0](status/grpc.raml#36-42)|Instance|The client specified an invalid argument. Note that this differs from FAILED_PRECONDITION. INVALID_ARGUMENT indicates arguments that are problematic regardless of the state of the system (e.g., a malformed file name). |
|[cti.a.p.status_code.v1.0~a.p.grpc.v1.0~a.p.ok.0.v1.0](status/grpc.raml#21-24)|Instance|Not an error; returned on success|
|[cti.a.p.status_code.v1.0~a.p.grpc.v1.0~a.p.unknown.2.v1.0](status/grpc.raml#29-35)|Instance|Unknown error. For example, this error may be returned when a Status value received from another address space belongs to an error space that is not known in this address space. Also errors raised by APIs that do not return enough error information may be converted to this error. |
|[cti.a.p.status_code.v1.0~a.p.http.v1.0](status/http.raml#13-19)|Type|HTTP statuses: https://developer.mozilla.org/en-US/docs/Web/HTTP/Status|
|[cti.a.p.status_code.v1.0~a.p.http.v1.0~a.p.bad_request.400.v1.0](status/http.raml#29-34)|Instance|The server cannot or will not process the request due to something that is perceived to be a client error (for example, malformed request syntax, invalid request message framing, or deceptive request routing) |
|[cti.a.p.status_code.v1.0~a.p.http.v1.0~a.p.created.201.v1.0](status/http.raml#25-28)|Instance|No error, the request has succeeded and has led to the creation of a resource|
|[cti.a.p.status_code.v1.0~a.p.http.v1.0~a.p.dts_func_error.550.v1.0](dts/types.raml#26-30)|Instance|The server encountered an unexpected DTS function error|
|[cti.a.p.status_code.v1.0~a.p.http.v1.0~a.p.internal_server_error.500.v1.0](status/http.raml#35-38)|Instance|The server encountered an unexpected condition that prevented it from fulfilling the request|
|[cti.a.p.status_code.v1.0~a.p.http.v1.0~a.p.ok.200.v1.0](status/http.raml#21-24)|Instance|No error, the request has succeeded|
|[cti.a.p.status_code.v1.0~a.p.linux_errno.v1.0](status/linux.raml#13-19)|Type|Linux specific errors (aka errno codes): https://dox.ipxe.org/errno_8h_source.html|
|[cti.a.p.status_code.v1.0~a.p.linux_errno.v1.0~a.p.econnaborted.103.v1.0](status/linux.raml#21-27)|Instance|This error code indicates that a connection has been aborted. It happens when a software causes a connection abort, which could be due to several reasons such as network issues, or the remote host using a "hard close". This error is defined as "Software caused connection abort". |
|[cti.a.p.status_code.v1.0~a.p.linux_errno.v1.0~a.p.econnrefused.111.v1.0](status/linux.raml#35-40)|Instance|This indicates that no one is listening on the remote address and port. This error occurs when an attempt to connect is made, but the target server rejects the connection. It's defined as "Connection refused".|
|[cti.a.p.status_code.v1.0~a.p.linux_errno.v1.0~a.p.econnreset.104.v1.0](status/linux.raml#28-34)|Instance|This error code is used to signal that a connection was forcibly closed by the peer. This could occur if the peer resets the connection rather than performing a proper shutdown, possibly due to a protocol error or time out. It's defined as "Connection reset by peer". |
|[cti.a.p.status_code.v1.0~a.p.macos_errno.v1.0](status/macos.raml#13-19)|Type|Mac OS (OSX) specific errors: https://developer.apple.com/library/archive/documentation/System/Conceptual/ManPages_iPhoneOS/man2/intro.2.html|
|[cti.a.p.status_code.v1.0~a.p.macos_errno.v1.0~a.p.econnaborted.53.v1.0](status/macos.raml#21-24)|Instance|Software caused connection abort. A connection abort was caused internal to your host machine|
|[cti.a.p.status_code.v1.0~a.p.macos_errno.v1.0~a.p.econnrefused.61.v1.0](status/macos.raml#29-34)|Instance|Connection refused. No connection could be made because the target machine actively refused it. This usually results from trying to connect to a service that is inactive on the foreign host.|
|[cti.a.p.status_code.v1.0~a.p.macos_errno.v1.0~a.p.econnreset.54.v1.0](status/macos.raml#25-28)|Instance|No error, the request has succeeded and has led to the creation of a resource|
|[cti.a.p.status_code.v1.0~a.p.websocket.v1.0](status/websocket.raml#13-19)|Type|WebSocket connection close codes: https://developer.mozilla.org/en-US/docs/Web/API/CloseEvent/code|
|[cti.a.p.status_code.v1.0~a.p.websocket.v1.0~a.p.going_away.1001.v1.0](status/websocket.raml#25-28)|Instance|Indicates that the endpoint is 'going away', such as a server going down or a browser having navigated away from a page.|
|[cti.a.p.status_code.v1.0~a.p.websocket.v1.0~a.p.normal_closure.1000.v1.0](status/websocket.raml#21-24)|Instance|The connection successfully completed the purpose for which it was created.|
|[cti.a.p.status_code.v1.0~a.p.websocket.v1.0~a.p.protocol_error.1002.v1.0](status/websocket.raml#29-32)|Instance|Used to indicate that an endpoint is terminating the connection due to a protocol error.|
|[cti.a.p.status_code.v1.0~a.p.websocket.v1.0~a.p.unsupported_data.1003.v1.0](status/websocket.raml#33-36)|Instance|Sent if an endpoint receives data of a type it cannot accept (for example, text data when expecting binary).|
