# Event management domain (Draft)

https://adn.acronis.com/display/AIG/Events
https://git.acronis.com/projects/ABC/repos/event-manager/browse/pkg



- [Event management domain (Draft)](#event-management-domain-draft)
  - [Event](#event)
    - [DB table](#db-table)
    - [API examples](#api-examples)
    - [Access check query](#access-check-query)
  - [Event Type](#event-type)
    - [DB table](#db-table-1)
    - [API examples](#api-examples-1)
    - [Access check query](#access-check-query-1)
  - [Event Topic](#event-topic)
    - [API examples](#api-examples-2)
    - [Access check query](#access-check-query-2)


## Event

Delivery Manager
  `GET /events?topic={topic}`

Event Ingest
  `POST /topics/{topic}/events`

### DB table

| id     | type (hash)                                                  | ... |
| ---    | ---                                                          | --- |
| 123132 | HASH(`cti.a.p.em.event_type.v1.0~a.p.test.async.event.v1.0`) |     |

### API examples

  - GET /events?type=`cti.a.p.em.event.v1.0~a.p.audit.v1.0`
  - GET /events?type=`cti.a.p.em.event.v1.0~a.p.audit.v1.0~b.c.*.v1.0`
  - GET /events?type=`cti.a.p.em.event.v1.0~a.p.audit.v1.0~b.c.d.v1.0`

  - GET /events?topic=`cti.a.p.em.topic.v1.0~a.b.*`
  - GET /events?type=`cti.a.p.em.event.v1.0~a.p.audit.v1.0&topic=cti.a.p.em.topic.v1.0~a.b.*`

### Access check query

  - `cti.a.p.em.event.v1.0[ type=cti.a.p.em.event.v1.0~a.p.audit.v1.0 ]`
  - `cti.a.p.em.event.v1.0[ type=cti.a.p.em.event.v1.0~a.p.audit.v1.0 & topic=cti.a.p.em.topic.v1.0~a.p.audit.v1.0 ]`
  - `cti.a.p.em.event.v1.0~a.p.audit.v1.0[ topic=cti.a.p.em.topic.v1.0~a.p.audit.v1.0 ]`

Short notation:

  - `cti.a.p.em.event.v1.0[ type=cti.a.p.em.event.v1.0~<XXX> ] == type=cti.a.p.em.event.v1.0~<XXX>`

  - `cti.a.p.em.event.v1.0[ type=cti.a.p.em.event.v1.0~a.p.audit.v1.0~a.p.script.created.v1.0 ]`
  - `cti.a.p.em.event.v1.0~a.p.audit.v1.0[ type=cti.a.p.em.event.v1.0~a.p.audit.v1.0~a.p.script.created.v1.0 ]`
  - `cti.a.p.em.event.v1.0~a.p.audit.v1.0~a.p.script.created.v1.0`

  - `cti.a.p.em.event.v1.0~a.p.audit.v1.0~a.p.script.created.v1.0`

## Event Type

Event Ingest
  `POST /topics/{topic}/types`

### DB table

| pk  | id (hash)                                                             | topic | schema | description | ... |
| --- | ---                                                                   | ---   | ---    | ---         | --- |
|     | HASH(`cti.a.p.em.event.v1.0~a.p.audit.v1.0~a.p.licensing.turn.on.v1.0`) |       |        |             |     |

closure table id (hash) -> `cti.a.p.em.event.v1.0~a.p.test.async.event.v1.0`


### API examples

  - GET /event_types?id=`cti.a.p.em.event.v1.0`
  - GET /event_types?id=`cti.a.p.em.event.v1.0~a.p.audit.v1.0`
  - GET /event_types?topic=`cti.a.p.em.topic.v1.0~a.b.*`

with artificial shortcut

  - GET /event_types/`cti.a.p.em.event_type.v1.0~a.p.audit.v1.0~a.p.licensing.turn.on.v1.0`


### Access check query

  - `cti.a.p.em.event_type.v1.0[id=cti.a.p.em.event.v1.0~a.p.audit.v1.0]`

Short notation (!!! Artificial shortcut !!!)

  - `cti.a.p.em.event_type.v1.0~a.p.audit.v1.0`

## Event Topic

Event Ingest
  `POST /topics`
  `GET /topics`

`cti.a.p.em.event.v1.0[ cti.a.p.em.event_type.v1.0[ id=type topic="cti.a.p.em.topic.v1.0~a.p.test.async.v1.0" ] ]`
`cti.a.p.em.event.v1.0[ topic="cti.a.p.em.topic.v1.0~a.p.test.async.v1.0" ]`

### API examples

  - GET /topics?id=`cti.a.p.em.topic.v1.0~a.p.audit.v1.0`
  - GET /topics/`cti.a.p.em.topic.v1.0~a.p.audit.v1.0`/events

### Access check query

  - `cti.a.p.em.topic.v1.0[id=cti.a.p.em.topic.v1.0~a.p.audit.v1.0]`
  - `cti.a.p.em.topic.v1.0~a.p.audit.v1.0`

Short notation

  - `cti.a.p.em.topic.v1.0[id=cti.a.p.em.topic.v1.0~<XXX>]` == `cti.a.p.em.topic.v1.0~<XXX>`
