# User-defined workflows

User-defined workflows should allow both end-users and vendors to create and configures workflows without deep knowledge in underlying specifications.

The must requirements from the business side is to provide seamless and easy to use Workflow builder that can be used by wide range of Acronis customers and partners.

The design is based on the existing technologies such as Serverless workflows and Acronis DTS function melding them together to achieve desired business goals.

User-defined workflows in general are agnostic to the underlying Serverless workflows specification version and acts only as high-level definitions, enriching user experience and as one of the main feature providing extendable library of building blocks for the authors.

TODO. As original Serverless workflows specification (both v0.7 and even v1.0) is not yet suitable for the end user not developer it is proposed to implement intermediate level of Flowcharts that can be one-way converted to the Serverless workflows and executed by Workflow engine. Main benefit of this approach is that we can use already existing and widely used and supported in industry technology of Serverless workflows for the low-level development but allow end customers to use simplified Workflow builder UI to create their own workflows achieving the business goals.

## Flowchart building blocks

### Triggers

Flowchart trigger defines entrance point of the flowchart and also defines an input for other flowcharts blocks in a convenient form.

#### Anatomy of triggers

Each trigger consist of initiator and data aggregator.

Scheduler defines conditions in that trigger and so the flowchart should be activated. And the data aggregator collects required information in a convenient form to pass it into the flowchart. Data aggregator may use output of scheduler and use it for data aggregation.

As an example event scheduler will produce __user_id__ as a result and data aggregator will take to produce User information.

Trigger may omit scheduler or data aggregator in certain cases, e.g.

| iInitiator | Data aggregator | Description |
| --- | --- | --- |
| + | + | Typical use-case of classic trigger, e.g. on EDR incident created. Flowchart with such trigger can be activated both on event or manually by passing EDR incident id as an input manually. |
| - | + | Flowchart could be activated by chron task and so data aggregator has no input. Bu anyway it may collect some data that will be used by the flowchart blocks. |
| - | + | TODO need to think on use-case when data aggregation is not required, so flowcharts only required passthrough input parameters as a trigger for manual activation. |
| + | - | In some use-case aggregator could be omitted so in that case output of the scheduler will be used as an output of the trigger. |
| - | - | Flowchart could be only activated manually without parameters. |

#### Some example of triggers

| | Initiator | Aggregator | Trigger output | Aggregator input / manual activation input |
| ----------------- | ----------------- | --- | --- | --- |
| Simple            | cron              | - | - | - |
| Simple EDR        | EDR create event  | - | Related event with payload | Related event with payload|
| EDR create event  | EDR create event  | aggregate data from EDR backend by incident id | EDR incident | EDR incident id |
| EDR updated event | EDR updated event | aggregate data from EDR backend by incident id | EDR incident | EDR incident id |

#### Multi-trigger flowchart

### Actions

Flowchart action represents actions that is performed by Flowchart engine. Actions are based on DTS functions but adds more semantics specific to flowcharts such as - flowchart category and user input configuration if it cannot be deduced from the DTS function specification directly.

Output and input block schema of the flowchart action are determined by the definition of underlying DTS function.

### Conditions

The role of pure generic condition block is to enable execution flow switch in the flowcharts, block by it's logic it very similar to switch block from DLS v1.0 but could be implemented on any other version of the specification.
