# EDR Flowchart example

``` yaml
id: aaea02e8-ecf1-45e9-9ade-6446a405d631
name: My Flowchart no localization

trigger: 
  id: f213a3e5-c6b7-40b9-aa62-047907a6e9e5
  type: cti.a.p.wf.flowchart.trigger.v1.0~a.p.event.v1.0~a.edr.trigger.v1.0
  name: EDR incident created

blocks:
- ...
- id: 7fa95805-df0e-499e-9685-8bff95024b58
  name: Stop process

- id: 3cd1cc2f-b1a9-42b0-91a2-245f015ca37b
  name: Quarantine the process

- id: 12771765-a16a-4e64-9db6-5ea7a1af3ab2
  name: Isolate device

- id: 17bb0d84-7ce8-4a11-857d-aa3b95735a9e
  name: Add comment
  type: cti.a.p.wf.flowchart.block.v1.0~a.p.action.v1.0~a.edr.add_comment.v1.0

  input_mapping:
    # cti.a.p.edr.incident.v1.0@id
    incident_id: .output[f213a3e5-c6b7-40b9-aa62-047907a6e9e5].id
    #
    comment: >
      Suspicious process {{ .output[f213a3e5-c6b7-40b9-aa62-047907a6e9e5].file_name }}
      was detected on {{ .output[f213a3e5-c6b7-40b9-aa62-047907a6e9e5].device_name }}.
      The following actions were performed -
      {{ .output[7fa95805-df0e-499e-9685-8bff95024b58].result }},
      {{ .output[3cd1cc2f-b1a9-42b0-91a2-245f015ca37b].result }},
      {{ .output[12771765-a16a-4e64-9db6-5ea7a1af3ab2].result }}.

  then: end

start: 17bb0d84-7ce8-4a11-857d-aa3b95735a9e
```

Serverless workflow:

```yaml
do:
- 17bb0d84-7ce8-4a11-857d-aa3b95735a9e # Add comment
  do:
  - 9a39671f-f2dc-4717-a5f0-b6e76332ba90
    call: dts
    with:
      func: cti.a.p.render_template.v1.0

      params:
        dictionary: ....
        templates:
          <key_1>: ... template 1
          ...

      returns:
        results:
        - key:
          rendered:
        - ...

  - 214f8028-2421-40e1-9a85-ff77fc0534fc
    call: dts
    with:
      func: cti.a.edr.add_comment.v1.0
    
    input:
      from:
        incident_id: .output[f213a3e5-c6b7-40b9-aa62-047907a6e9e5].id
        comment: .local_output[9a39671f-f2dc-4717-a5f0-b6e76332ba90].results[comment]
```
