# Table of contents
1. [Policy Creation](#policy_creation)
2. [Draft Creation](#draft_creation)
3. [Switching Mapping Type](#switch_mapping_type)
4. [Add Mapping](#add_mapping)
5. [Changing Existing Mapping](#change_mapping)
6. [Excluding Disk or Volume from Mapping](#exclude_from_mapping)
7. [Clearing Mapping](#clear_mapping)
8. [Requesting Available Targets for Specified Source](#get_available_target)
9. [Changing of Files/Folders List](#change_files_folders)
10. [Changing of Target Location](#change_target_location)
11. [Removing Target Location](#remove_target_location)
12. [Changing of Options](#change_options)

# 1. Policy Creation <a name="policy_creation"></a>
## Request
The following request creates policy of recovery entire machine from image backup. 
Disks will be mapped automatically during recovery process because "disks_volumes_mapping" is absent.
```http
POST /policies
```
```json5
{
    "subject":
    {
        "policy":
        [
            {
                "type":"policy.recovery.image",
                "settings":
                {
                    "recovery_point":
                    {
                        "vault_id":"bdbdefe2-a5e2-4bc3-b947-f38f789832f8",
                        "archive_id":"c01dfd78-2b38-11ec-8d3d-0242ac130003",
                        "backup_id":"c4c08594-2b38-11ec-8d3d-0242ac130003"
                    },
                    "target_resource_id":"cfdda592-2b38-11ec-8d3d-0242ac130003"
                }
            }
        ]
    }
}
```
## Response
```json5
{
    "result":["50064f7a-2b53-11ec-8d3d-0242ac130003"]
}
```

# 2. Draft Creation <a name="draft_creation"></a>
UI makes this request to create draft of recovery policy for further tuning that draft by user. 
## Request
```http
POST /drafts
```
```json5
{
  "new": {
    "policy": [
      {
        "type": "policy.recovery.image",
        "settings": {
          "recovery_point": {
            "vault_id": "bdbdefe2-a5e2-4bc3-b947-f38f789832f8",
            "archive_id": "c01dfd78-2b38-11ec-8d3d-0242ac130003",
            "backup_id": "c4c08594-2b38-11ec-8d3d-0242ac130003"
          },
          "target_resource_id": "cfdda592-2b38-11ec-8d3d-0242ac130003"
        }
      }
    ]
  }
}
```
## Response
Recovery GRPM addon returns draft of recovery policy with disk mapping made automatically. 
Constraints in the returned policy descibe all disks and volumes contained in the archive and all disks, volumes, unaloccated space in the target machine.
```json5
{
  "id": "1fb3b58c-2b3b-11ec-8d3d-0242ac130003",
  "policy": [
    {
      "id": "27fa84d2-2b3b-11ec-8d3d-0242ac130003",
      "type": "policy.recovery.image",
      "settings": {
        "recovery_point": {
          "vault_id": "bdbdefe2-a5e2-4bc3-b947-f38f789832f8",
          "archive_id": "c01dfd78-2b38-11ec-8d3d-0242ac130003",
          "backup_id": "c4c08594-2b38-11ec-8d3d-0242ac130003"
        },
        "target_resource_id": "cfdda592-2b38-11ec-8d3d-0242ac130003",
        "disks_volumes_mapping": [
          {
            "source": "[[\"ItemType\",\"dms:disk\"],[\"LocalID\",\"discID=%5clocal%5chd_sign(C8607E65)&slice=avfs%3a%2fonline%3faccount%253dGreenUnitUser%2526computer%253d1%2526provider%253dAcronis%23arl%3a%2f8CCB15FB-245C-4E11-9E08-ACF901EF05CA%2f8F44EB8E-E15E-4B3E-BBC4-40924F7EE303%2f9DA25A19-9E70-495E-0CBD-B0BB04FDADD5%2f4A6C57BC-E6EC-493C-9F86-B918475FA8DD%3farchive_name%253dWin7x64-d-titov-67B7AF37-B570-4ECA-A5E6-1FFCB613C49E-1A1B9452-5688-4C82-9AA8-31786D8DF757A\"]]",
            "target": "[[\"ItemType\",\"mms::disk::disk\"],[\"LocalID\",\"\\\\local\\\\hd_sign(C8607E65)\"]]"
          }
        ]
      },
      "settingsConstraints": {
        "sources": [
          {
            "type": "VOLUME",
            "id": "[[\"ItemType\",\"dms:volume\"],[\"LocalID\",\"discID=%5clocal%5chd_sign(C8607E65)&slice=avfs%3a%2fonline%3faccount%253dGreenUnitUser%2526computer%253d1%2526provider%253dAcronis%23arl%3a%2f8CCB15FB-245C-4E11-9E08-ACF901EF05CA%2f8F44EB8E-E15E-4B3E-BBC4-40924F7EE303%2f9DA25A19-9E70-495E-0CBD-B0BB04FDADD5%2f4A6C57BC-E6EC-493C-9F86-B918475FA8DD%3farchive_name%253dWin7x64-d-titov-67B7AF37-B570-4ECA-A5E6-1FFCB613C49E-1A1B9452-5688-4C82-9AA8-31786D8DF757A&spaceID=%5clocal%5chd_sign(C8607E65)%5cpart_sn(ACD6863C4CACD6A2)start(2048)\"]]",
            "name": "System Reserved",
            "disks": [
              "[[\"ItemType\",\"dms:disk\"],[\"LocalID\",\"discID=%5clocal%5chd_sign(C8607E65)&slice=avfs%3a%2fonline%3faccount%253dGreenUnitUser%2526computer%253d1%2526provider%253dAcronis%23arl%3a%2f8CCB15FB-245C-4E11-9E08-ACF901EF05CA%2f8F44EB8E-E15E-4B3E-BBC4-40924F7EE303%2f9DA25A19-9E70-495E-0CBD-B0BB04FDADD5%2f4A6C57BC-E6EC-493C-9F86-B918475FA8DD%3farchive_name%253dWin7x64-d-titov-67B7AF37-B570-4ECA-A5E6-1FFCB613C49E-1A1B9452-5688-4C82-9AA8-31786D8DF757A\"]]"
            ],
            "size": 104857600,
            "free_space": 45826048,
            "file_system": "NTFS"
          },
          {
            "type": "VOLUME",
            "id": "[[\"ItemType\",\"dms:volume\"],[\"LocalID\",\"discID=%5clocal%5chd_sign(C8607E65)&slice=avfs%3a%2fonline%3faccount%253dGreenUnitUser%2526computer%253d1%2526provider%253dAcronis%23arl%3a%2f8CCB15FB-245C-4E11-9E08-ACF901EF05CA%2f8F44EB8E-E15E-4B3E-BBC4-40924F7EE303%2f9DA25A19-9E70-495E-0CBD-B0BB04FDADD5%2f4A6C57BC-E6EC-493C-9F86-B918475FA8DD%3farchive_name%253dWin7x64-d-titov-67B7AF37-B570-4ECA-A5E6-1FFCB613C49E-1A1B9452-5688-4C82-9AA8-31786D8DF757A&spaceID=%5clocal%5chd_sign(C8607E65)%5cpart_sn(7CD902E3D67CD927)start(206848)\"]]",
            "name": "NTFS (C:)",
            "disks": [
              "[[\"ItemType\",\"dms:disk\"],[\"LocalID\",\"discID=%5clocal%5chd_sign(C8607E65)&slice=avfs%3a%2fonline%3faccount%253dGreenUnitUser%2526computer%253d1%2526provider%253dAcronis%23arl%3a%2f8CCB15FB-245C-4E11-9E08-ACF901EF05CA%2f8F44EB8E-E15E-4B3E-BBC4-40924F7EE303%2f9DA25A19-9E70-495E-0CBD-B0BB04FDADD5%2f4A6C57BC-E6EC-493C-9F86-B918475FA8DD%3farchive_name%253dWin7x64-d-titov-67B7AF37-B570-4ECA-A5E6-1FFCB613C49E-1A1B9452-5688-4C82-9AA8-31786D8DF757A\"]]"
            ],
            "size": 64317554688,
            "free_space": 34326716416,
            "file_system": "NTFS"
          },
          {
            "type": "Disk",
            "id": "[[\"ItemType\",\"dms:disk\"],[\"LocalID\",\"discID=%5clocal%5chd_sign(C8607E65)&slice=avfs%3a%2fonline%3faccount%253dGreenUnitUser%2526computer%253d1%2526provider%253dAcronis%23arl%3a%2f8CCB15FB-245C-4E11-9E08-ACF901EF05CA%2f8F44EB8E-E15E-4B3E-BBC4-40924F7EE303%2f9DA25A19-9E70-495E-0CBD-B0BB04FDADD5%2f4A6C57BC-E6EC-493C-9F86-B918475FA8DD%3farchive_name%253dWin7x64-d-titov-67B7AF37-B570-4ECA-A5E6-1FFCB613C49E-1A1B9452-5688-4C82-9AA8-31786D8DF757A\"]]",
            "name": "Disk 1",
            "model": "Virtual HD 1.1.0",
            "size": 64424509440
          }
        ],
        "targets": [
          {
            "type": "Disk",
            "id": "[[\"ItemType\",\"mms::disk::disk\"],[\"LocalID\",\"\\\\local\\\\hd_sign(C8607E65)\"]]",
            "name": "Disk 1",
            "model": "Virtual HD 1.1.0",
            "size": 64424509440
          },
          {
            "type": "VOLUME",
            "id": "[[\"ItemType\",\"mms::disk::volume\"],[\"LocalID\",\"\\\\local\\\\hd_sign(C8607E65)\\\\part_sn(ACD6863C4CACD6A2)start(2048)\"]]",
            "name": "System Reserved",
            "disks": [
              "[[\"ItemType\",\"mms::disk::disk\"],[\"LocalID\",\"\\\\local\\\\hd_sign(C8607E65)\"]]"
            ],
            "size": 104857600,
            "occupied_size": 25473024,
            "file_system": "NTFS"
          },
          {
            "type": "VOLUME",
            "id": "[[\"ItemType\",\"mms::disk::volume\"],[\"LocalID\",\"\\\\local\\\\hd_sign(C8607E65)\\\\part_sn(7CD902E3D67CD927)start(206848)\"]]",
            "name": "NTFS (C:)",
            "disks": [
              "[[\"ItemType\",\"mms::disk::disk\"],[\"LocalID\",\"\\\\local\\\\hd_sign(C8607E65)\"]]"
            ],
            "size": 64317554688,
            "occupied_size": 32882847744,
            "file_system": "NTFS"
          },
          {
            "type": "VOLUME",
            "id": "[[\"ItemType\",\"mms::disk::free_space\"],[\"LocalID\",\"\\\\local\\\\hd_sign(C8607E65)\\\\num(2)\"]]",
            "name": "Unallocated",
            "disks": [
              "[[\"ItemType\",\"mms::disk::disk\"],[\"LocalID\",\"\\\\local\\\\hd_sign(C8607E65)\"]]"
            ],
            "size": 1048576
          }
        ],
        "mapping_type": "DISKS",
        "disks_volumes_mapping" : [
          {
            "target":{
              "id":"[[\"ItemType\",\"mms::disk::disk\"],[\"LocalID\",\"\\\\local\\\\hd_sign(C8607E65)\"]]",
              "is_clearable":false,
              "is_changeable":true
            }
          }
        ]
      }
    }
  ]
}
```
# 3. Switching Mapping Type<a name="switch_mapping_type"></a>
## Request
```http
PATCH /drafts/{draft id}/policies/{policy id}/settings
content_type: application/json-patch+json
```
```json5
{
    "op": "replace",
    "path": "/mapping_type",
    "value": "VOLUMES" 
}
```
## Response
Recovery GRPM addon returns draft of recovery policy with volume mapping made automatically. 
Constraints in the returned policy descibe all disks and volumes contained in the archive and all disks, volumes, unaloccated space in the target machine.
```json5
{
  "id": "1fb3b58c-2b3b-11ec-8d3d-0242ac130003",
  "policy": [
    {
      "id": "27fa84d2-2b3b-11ec-8d3d-0242ac130003",
      "type": "policy.recovery.image",
      "settings": {
        "recovery_point": {
          "vault_id": "bdbdefe2-a5e2-4bc3-b947-f38f789832f8",
          "archive_id": "c01dfd78-2b38-11ec-8d3d-0242ac130003",
          "backup_id": "c4c08594-2b38-11ec-8d3d-0242ac130003"
        },
        "target_resource_id": "cfdda592-2b38-11ec-8d3d-0242ac130003",
        "disks_volumes_mapping": [
          {
            "source": "[[\"ItemType\",\"dms:volume\"],[\"LocalID\",\"discID=%5clocal%5chd_sign(C8607E65)&slice=avfs%3a%2fonline%3faccount%253dGreenUnitUser%2526computer%253d1%2526provider%253dAcronis%23arl%3a%2f8CCB15FB-245C-4E11-9E08-ACF901EF05CA%2f8F44EB8E-E15E-4B3E-BBC4-40924F7EE303%2f9DA25A19-9E70-495E-0CBD-B0BB04FDADD5%2f4A6C57BC-E6EC-493C-9F86-B918475FA8DD%3farchive_name%253dWin7x64-d-titov-67B7AF37-B570-4ECA-A5E6-1FFCB613C49E-1A1B9452-5688-4C82-9AA8-31786D8DF757A&spaceID=%5clocal%5chd_sign(C8607E65)%5cpart_sn(ACD6863C4CACD6A2)start(2048)\"]]",
            "target": "[[\"ItemType\",\"mms::disk::volume\"],[\"LocalID\",\"\\\\local\\\\hd_sign(C8607E65)\\\\part_sn(ACD6863C4CACD6A2)start(2048)\"]]"
          },
          {
            "source": "[[\"ItemType\",\"dms:volume\"],[\"LocalID\",\"discID=%5clocal%5chd_sign(C8607E65)&slice=avfs%3a%2fonline%3faccount%253dGreenUnitUser%2526computer%253d1%2526provider%253dAcronis%23arl%3a%2f8CCB15FB-245C-4E11-9E08-ACF901EF05CA%2f8F44EB8E-E15E-4B3E-BBC4-40924F7EE303%2f9DA25A19-9E70-495E-0CBD-B0BB04FDADD5%2f4A6C57BC-E6EC-493C-9F86-B918475FA8DD%3farchive_name%253dWin7x64-d-titov-67B7AF37-B570-4ECA-A5E6-1FFCB613C49E-1A1B9452-5688-4C82-9AA8-31786D8DF757A&spaceID=%5clocal%5chd_sign(C8607E65)%5cpart_sn(7CD902E3D67CD927)start(206848)\"]]",
            "target": "[[\"ItemType\",\"mms::disk::volume\"],[\"LocalID\",\"\\\\local\\\\hd_sign(C8607E65)\\\\part_sn(7CD902E3D67CD927)start(206848)\"]]"
          }
        ]
      },
      "settingsConstraints": {
        "sources": [
          {
            "type": "VOLUME",
            "id": "[[\"ItemType\",\"dms:volume\"],[\"LocalID\",\"discID=%5clocal%5chd_sign(C8607E65)&slice=avfs%3a%2fonline%3faccount%253dGreenUnitUser%2526computer%253d1%2526provider%253dAcronis%23arl%3a%2f8CCB15FB-245C-4E11-9E08-ACF901EF05CA%2f8F44EB8E-E15E-4B3E-BBC4-40924F7EE303%2f9DA25A19-9E70-495E-0CBD-B0BB04FDADD5%2f4A6C57BC-E6EC-493C-9F86-B918475FA8DD%3farchive_name%253dWin7x64-d-titov-67B7AF37-B570-4ECA-A5E6-1FFCB613C49E-1A1B9452-5688-4C82-9AA8-31786D8DF757A&spaceID=%5clocal%5chd_sign(C8607E65)%5cpart_sn(ACD6863C4CACD6A2)start(2048)\"]]",
            "name": "System Reserved",
            "disks": [
              "[[\"ItemType\",\"dms:disk\"],[\"LocalID\",\"discID=%5clocal%5chd_sign(C8607E65)&slice=avfs%3a%2fonline%3faccount%253dGreenUnitUser%2526computer%253d1%2526provider%253dAcronis%23arl%3a%2f8CCB15FB-245C-4E11-9E08-ACF901EF05CA%2f8F44EB8E-E15E-4B3E-BBC4-40924F7EE303%2f9DA25A19-9E70-495E-0CBD-B0BB04FDADD5%2f4A6C57BC-E6EC-493C-9F86-B918475FA8DD%3farchive_name%253dWin7x64-d-titov-67B7AF37-B570-4ECA-A5E6-1FFCB613C49E-1A1B9452-5688-4C82-9AA8-31786D8DF757A\"]]"
            ],
            "size": 104857600,
            "free_space": 45826048,
            "file_system": "NTFS"
          },
          {
            "type": "VOLUME",
            "id": "[[\"ItemType\",\"dms:volume\"],[\"LocalID\",\"discID=%5clocal%5chd_sign(C8607E65)&slice=avfs%3a%2fonline%3faccount%253dGreenUnitUser%2526computer%253d1%2526provider%253dAcronis%23arl%3a%2f8CCB15FB-245C-4E11-9E08-ACF901EF05CA%2f8F44EB8E-E15E-4B3E-BBC4-40924F7EE303%2f9DA25A19-9E70-495E-0CBD-B0BB04FDADD5%2f4A6C57BC-E6EC-493C-9F86-B918475FA8DD%3farchive_name%253dWin7x64-d-titov-67B7AF37-B570-4ECA-A5E6-1FFCB613C49E-1A1B9452-5688-4C82-9AA8-31786D8DF757A&spaceID=%5clocal%5chd_sign(C8607E65)%5cpart_sn(7CD902E3D67CD927)start(206848)\"]]",
            "name": "NTFS (C:)",
            "disks": [
              "[[\"ItemType\",\"dms:disk\"],[\"LocalID\",\"discID=%5clocal%5chd_sign(C8607E65)&slice=avfs%3a%2fonline%3faccount%253dGreenUnitUser%2526computer%253d1%2526provider%253dAcronis%23arl%3a%2f8CCB15FB-245C-4E11-9E08-ACF901EF05CA%2f8F44EB8E-E15E-4B3E-BBC4-40924F7EE303%2f9DA25A19-9E70-495E-0CBD-B0BB04FDADD5%2f4A6C57BC-E6EC-493C-9F86-B918475FA8DD%3farchive_name%253dWin7x64-d-titov-67B7AF37-B570-4ECA-A5E6-1FFCB613C49E-1A1B9452-5688-4C82-9AA8-31786D8DF757A\"]]"
            ],
            "size": 64317554688,
            "free_space": 34326716416,
            "file_system": "NTFS"
          },
          {
            "type": "Disk",
            "id": "[[\"ItemType\",\"dms:disk\"],[\"LocalID\",\"discID=%5clocal%5chd_sign(C8607E65)&slice=avfs%3a%2fonline%3faccount%253dGreenUnitUser%2526computer%253d1%2526provider%253dAcronis%23arl%3a%2f8CCB15FB-245C-4E11-9E08-ACF901EF05CA%2f8F44EB8E-E15E-4B3E-BBC4-40924F7EE303%2f9DA25A19-9E70-495E-0CBD-B0BB04FDADD5%2f4A6C57BC-E6EC-493C-9F86-B918475FA8DD%3farchive_name%253dWin7x64-d-titov-67B7AF37-B570-4ECA-A5E6-1FFCB613C49E-1A1B9452-5688-4C82-9AA8-31786D8DF757A\"]]",
            "name": "Disk 1",
            "model": "Virtual HD 1.1.0",
            "size": 64424509440
          }
        ],
        "targets": [
          {
            "type": "Disk",
            "id": "[[\"ItemType\",\"mms::disk::disk\"],[\"LocalID\",\"\\\\local\\\\hd_sign(C8607E65)\"]]",
            "name": "Disk 1",
            "model": "Virtual HD 1.1.0",
            "size": 64424509440
          },
          {
            "type": "VOLUME",
            "id": "[[\"ItemType\",\"mms::disk::volume\"],[\"LocalID\",\"\\\\local\\\\hd_sign(C8607E65)\\\\part_sn(ACD6863C4CACD6A2)start(2048)\"]]",
            "name": "System Reserved",
            "disks": [
              "[[\"ItemType\",\"mms::disk::disk\"],[\"LocalID\",\"\\\\local\\\\hd_sign(C8607E65)\"]]"
            ],
            "size": 104857600,
            "occupied_size": 25473024,
            "file_system": "NTFS"
          },
          {
            "type": "VOLUME",
            "id": "[[\"ItemType\",\"mms::disk::volume\"],[\"LocalID\",\"\\\\local\\\\hd_sign(C8607E65)\\\\part_sn(7CD902E3D67CD927)start(206848)\"]]",
            "name": "NTFS (C:)",
            "disks": [
              "[[\"ItemType\",\"mms::disk::disk\"],[\"LocalID\",\"\\\\local\\\\hd_sign(C8607E65)\"]]"
            ],
            "size": 64317554688,
            "occupied_size": 32882847744,
            "file_system": "NTFS"
          },
          {
            "type": "VOLUME",
            "id": "[[\"ItemType\",\"mms::disk::free_space\"],[\"LocalID\",\"\\\\local\\\\hd_sign(C8607E65)\\\\num(2)\"]]",
            "name": "Unallocated",
            "disks": [
              "[[\"ItemType\",\"mms::disk::disk\"],[\"LocalID\",\"\\\\local\\\\hd_sign(C8607E65)\"]]"
            ],
            "size": 1048576
          }
        ],
        "mapping_type": "VOLUMES",
        "disks_volumes_mapping" : [
          {
            "target":{
              "id":"[[\"ItemType\",\"mms::disk::volume\"],[\"LocalID\",\"\\\\local\\\\hd_sign(C8607E65)\\\\part_sn(ACD6863C4CACD6A2)start(2048)\"]",
              "is_clearable":true,
              "is_changeable":false
            }
          },
          {
            "target":{
              "id":"[[\"ItemType\",\"mms::disk::volume\"],[\"LocalID\",\"\\\\local\\\\hd_sign(C8607E65)\\\\part_sn(7CD902E3D67CD927)start(206848)\"]]",
              "is_clearable":false,
              "is_changeable":true
            }
          }
        ]
      }
    }
  ]
}
```

# 4. Add Mapping <a name="add_mapping"></a>
## Request
```http
PATCH /drafts/{draft id}/policies/{policy id}/settings
content_type: application/json-patch+json
```
```json5
{
    "op": "add",
    "path": "/disks_volumes_mapping/-",
    "value": "{"source":"[[\"ItemType\",\"dms:volume\"],[\"LocalID\",\"discID=%5clocal%5chd_sign(C8607E65)&slice=avfs%3a%2fonline%3faccount%253dGreenUnitUser%2526computer%253d1%2526provider%253dAcronis%23arl%3a%2f8CCB15FB-245C-4E11-9E08-ACF901EF05CA%2f8F44EB8E-E15E-4B3E-BBC4-40924F7EE303%2f9DA25A19-9E70-495E-0CBD-B0BB04FDADD5%2f4A6C57BC-E6EC-493C-9F86-B918475FA8DD%3farchive_name%253dWin7x64-d-titov-67B7AF37-B570-4ECA-A5E6-1FFCB613C49E-1A1B9452-5688-4C82-9AA8-31786D8DF757A&spaceID=%5clocal%5chd_sign(C8607E65)%5cpart_sn(ACD6863C4CACD6A2)start(2048)\"]]","target":"[[\"ItemType\",\"mms::disk::volume\"],[\"LocalID\",\"\\\\local\\\\hd_sign(C8607E65)\\\\part_sn(7CD902E3D67CD927)start(206848)\"]]"}
}
```

# 5. Changing Existing Mapping <a name="change_mapping"></a>
To change mapping it is enough to change appropriate target in **settings**
## Request
```http
PATCH /drafts/{draft id}/policies/{policy id}/settings
content_type: application/json-patch+json
```
```json5
{
    "op": "replace",
    "path": "/disks_volumes_mapping/0/target",
    "value": "[[\"ItemType\",\"mms::disk::volume\"],[\"LocalID\",\"\\\\local\\\\hd_sign(C8607E65)\\\\part_sn(7CD902E3D67CD927)start(206848)\"]]"
}
```

# 6. Excluding Disk or Volume from Mapping <a name="exclude_from_mapping"></a>
To exclude disk or volume from mapping it is enough to empty appropriate target in **settings**
## Request
```http
PATCH /drafts/{draft id}/policies/{policy id}/settings
content_type: application/json-patch+json
```
```json5
{
    "op": "replace",
    "path": "/disks_volumes_mapping/0/target",
    "value": null
}
```
# 7. Clearing Mapping <a name="clear_mapping"></a>
To clear mapping  UI sends empty **disks_volumes_mapping** in **settings**
## Request
```http
PATCH /drafts/{draft id}/policies/{policy id}/settings
content_type: application/json-patch+json
```
```json5
{
    "op": "replace",
    "path": "/disks_volumes_mapping",
    "value": []
}
```

# 8. Requesting Available Targets for Specified Source <a name="get_available_target"></a>
## Request
```http
PATCH /drafts/{draft id}/policies/{policy id}/settings_constraints
content_type: application/json-patch+json
```
```json5
{
    "op": "add",
    "path": "/disks_volumes_mapping/0/available_targets",
    "value": null
}
```
## Response
In response there is whole draft with available targets put into constraints for specified source
```json5
{
  "id": "1fb3b58c-2b3b-11ec-8d3d-0242ac130003",
  "policy": [
    {
      "id": "27fa84d2-2b3b-11ec-8d3d-0242ac130003",
      "type": "policy.recovery.image",
      "settings": {
        "recovery_point": {
          "vault_id": "bdbdefe2-a5e2-4bc3-b947-f38f789832f8",
          "archive_id": "c01dfd78-2b38-11ec-8d3d-0242ac130003",
          "backup_id": "c4c08594-2b38-11ec-8d3d-0242ac130003"
        },
        "target_resource_id": "cfdda592-2b38-11ec-8d3d-0242ac130003",
        "disks_volumes_mapping": [
          {
            "source": "[[\"ItemType\",\"dms:disk\"],[\"LocalID\",\"discID=%5clocal%5chd_sign(C8607E65)&slice=avfs%3a%2fonline%3faccount%253dGreenUnitUser%2526computer%253d1%2526provider%253dAcronis%23arl%3a%2f8CCB15FB-245C-4E11-9E08-ACF901EF05CA%2f8F44EB8E-E15E-4B3E-BBC4-40924F7EE303%2f9DA25A19-9E70-495E-0CBD-B0BB04FDADD5%2f4A6C57BC-E6EC-493C-9F86-B918475FA8DD%3farchive_name%253dWin7x64-d-titov-67B7AF37-B570-4ECA-A5E6-1FFCB613C49E-1A1B9452-5688-4C82-9AA8-31786D8DF757A\"]]",
            "target": "[[\"ItemType\",\"mms::disk::disk\"],[\"LocalID\",\"\\\\local\\\\hd_sign(C8607E65)\"]]"
          }
        ]
      },
      "settingsConstraints": {
        "sources": [
          {
            "type": "VOLUME",
            "id": "[[\"ItemType\",\"dms:volume\"],[\"LocalID\",\"discID=%5clocal%5chd_sign(C8607E65)&slice=avfs%3a%2fonline%3faccount%253dGreenUnitUser%2526computer%253d1%2526provider%253dAcronis%23arl%3a%2f8CCB15FB-245C-4E11-9E08-ACF901EF05CA%2f8F44EB8E-E15E-4B3E-BBC4-40924F7EE303%2f9DA25A19-9E70-495E-0CBD-B0BB04FDADD5%2f4A6C57BC-E6EC-493C-9F86-B918475FA8DD%3farchive_name%253dWin7x64-d-titov-67B7AF37-B570-4ECA-A5E6-1FFCB613C49E-1A1B9452-5688-4C82-9AA8-31786D8DF757A&spaceID=%5clocal%5chd_sign(C8607E65)%5cpart_sn(ACD6863C4CACD6A2)start(2048)\"]]",
            "name": "System Reserved",
            "disks": [
              "[[\"ItemType\",\"dms:disk\"],[\"LocalID\",\"discID=%5clocal%5chd_sign(C8607E65)&slice=avfs%3a%2fonline%3faccount%253dGreenUnitUser%2526computer%253d1%2526provider%253dAcronis%23arl%3a%2f8CCB15FB-245C-4E11-9E08-ACF901EF05CA%2f8F44EB8E-E15E-4B3E-BBC4-40924F7EE303%2f9DA25A19-9E70-495E-0CBD-B0BB04FDADD5%2f4A6C57BC-E6EC-493C-9F86-B918475FA8DD%3farchive_name%253dWin7x64-d-titov-67B7AF37-B570-4ECA-A5E6-1FFCB613C49E-1A1B9452-5688-4C82-9AA8-31786D8DF757A\"]]"
            ],
            "size": 104857600,
            "free_space": 45826048,
            "file_system": "NTFS"
          },
          {
            "type": "VOLUME",
            "id": "[[\"ItemType\",\"dms:volume\"],[\"LocalID\",\"discID=%5clocal%5chd_sign(C8607E65)&slice=avfs%3a%2fonline%3faccount%253dGreenUnitUser%2526computer%253d1%2526provider%253dAcronis%23arl%3a%2f8CCB15FB-245C-4E11-9E08-ACF901EF05CA%2f8F44EB8E-E15E-4B3E-BBC4-40924F7EE303%2f9DA25A19-9E70-495E-0CBD-B0BB04FDADD5%2f4A6C57BC-E6EC-493C-9F86-B918475FA8DD%3farchive_name%253dWin7x64-d-titov-67B7AF37-B570-4ECA-A5E6-1FFCB613C49E-1A1B9452-5688-4C82-9AA8-31786D8DF757A&spaceID=%5clocal%5chd_sign(C8607E65)%5cpart_sn(7CD902E3D67CD927)start(206848)\"]]",
            "name": "NTFS (C:)",
            "disks": [
              "[[\"ItemType\",\"dms:disk\"],[\"LocalID\",\"discID=%5clocal%5chd_sign(C8607E65)&slice=avfs%3a%2fonline%3faccount%253dGreenUnitUser%2526computer%253d1%2526provider%253dAcronis%23arl%3a%2f8CCB15FB-245C-4E11-9E08-ACF901EF05CA%2f8F44EB8E-E15E-4B3E-BBC4-40924F7EE303%2f9DA25A19-9E70-495E-0CBD-B0BB04FDADD5%2f4A6C57BC-E6EC-493C-9F86-B918475FA8DD%3farchive_name%253dWin7x64-d-titov-67B7AF37-B570-4ECA-A5E6-1FFCB613C49E-1A1B9452-5688-4C82-9AA8-31786D8DF757A\"]]"
            ],
            "size": 64317554688,
            "free_space": 34326716416,
            "file_system": "NTFS"
          },
          {
            "type": "Disk",
            "id": "[[\"ItemType\",\"dms:disk\"],[\"LocalID\",\"discID=%5clocal%5chd_sign(C8607E65)&slice=avfs%3a%2fonline%3faccount%253dGreenUnitUser%2526computer%253d1%2526provider%253dAcronis%23arl%3a%2f8CCB15FB-245C-4E11-9E08-ACF901EF05CA%2f8F44EB8E-E15E-4B3E-BBC4-40924F7EE303%2f9DA25A19-9E70-495E-0CBD-B0BB04FDADD5%2f4A6C57BC-E6EC-493C-9F86-B918475FA8DD%3farchive_name%253dWin7x64-d-titov-67B7AF37-B570-4ECA-A5E6-1FFCB613C49E-1A1B9452-5688-4C82-9AA8-31786D8DF757A\"]]",
            "name": "Disk 1",
            "model": "Virtual HD 1.1.0",
            "size": 64424509440
          }
        ],
        "targets": [
          {
            "type": "Disk",
            "id": "[[\"ItemType\",\"mms::disk::disk\"],[\"LocalID\",\"\\\\local\\\\hd_sign(C8607E65)\"]]",
            "name": "Disk 1",
            "model": "Virtual HD 1.1.0",
            "size": 64424509440
          },
          {
            "type": "VOLUME",
            "id": "[[\"ItemType\",\"mms::disk::volume\"],[\"LocalID\",\"\\\\local\\\\hd_sign(C8607E65)\\\\part_sn(ACD6863C4CACD6A2)start(2048)\"]]",
            "name": "System Reserved",
            "disks": [
              "[[\"ItemType\",\"mms::disk::disk\"],[\"LocalID\",\"\\\\local\\\\hd_sign(C8607E65)\"]]"
            ],
            "size": 104857600,
            "occupied_size": 25473024,
            "file_system": "NTFS"
          },
          {
            "type": "VOLUME",
            "id": "[[\"ItemType\",\"mms::disk::volume\"],[\"LocalID\",\"\\\\local\\\\hd_sign(C8607E65)\\\\part_sn(7CD902E3D67CD927)start(206848)\"]]",
            "name": "NTFS (C:)",
            "disks": [
              "[[\"ItemType\",\"mms::disk::disk\"],[\"LocalID\",\"\\\\local\\\\hd_sign(C8607E65)\"]]"
            ],
            "size": 64317554688,
            "occupied_size": 32882847744,
            "file_system": "NTFS"
          },
          {
            "type": "VOLUME",
            "id": "[[\"ItemType\",\"mms::disk::free_space\"],[\"LocalID\",\"\\\\local\\\\hd_sign(C8607E65)\\\\num(2)\"]]",
            "name": "Unallocated",
            "disks": [
              "[[\"ItemType\",\"mms::disk::disk\"],[\"LocalID\",\"\\\\local\\\\hd_sign(C8607E65)\"]]"
            ],
            "size": 1048576
          }
        ],
        "mapping_type": "DISKS",
        "disks_volumes_mapping": [
          {
            "source": {
                "id":"[[\"ItemType\",\"dms:disk\"],[\"LocalID\",\"discID=%5clocal%5chd_sign(C8607E65)&slice=avfs%3a%2fonline%3faccount%253dGreenUnitUser%2526computer%253d1%2526provider%253dAcronis%23arl%3a%2f8CCB15FB-245C-4E11-9E08-ACF901EF05CA%2f8F44EB8E-E15E-4B3E-BBC4-40924F7EE303%2f9DA25A19-9E70-495E-0CBD-B0BB04FDADD5%2f4A6C57BC-E6EC-493C-9F86-B918475FA8DD%3farchive_name%253dWin7x64-d-titov-67B7AF37-B570-4ECA-A5E6-1FFCB613C49E-1A1B9452-5688-4C82-9AA8-31786D8DF757A\"]]",
                "available_targets": [
                  {
                    "id":"[[\"ItemType\",\"mms::disk::disk\"],[\"LocalID\",\"\\\\local\\\\hd_sign(C8607E65)\"]",
                    "verdict": {
                      "is_allowed":true,
                      "warrnings":[],
                      "errors":[]
                    }
                  }
                ]
            }
          }
        ]
      }
    }
  ]
}
```

# 9. Changing of Files/Folders List <a name="change_files_folders"></a>
## Request
```http
PATCH /drafts/{draft id}/policies/{policy id}/settings
content_type: application/json-patch+json
```
```json5
{
    "op": "replace",
    "path": "/files_folders",
    "value": [{"type":"DIR","path":"c:\\my_dir"},{"type":"FILE","path":"c:\\my_file"}]
}
```

# 10. Changing of Target Location <a name="change_target_location"></a>
## Request
```http
PATCH /drafts/{draft id}/policies/{policy id}/settings
content_type: application/json-patch+json
```
```json5
{
    "op": "replace",
    "path": "/target_location",
    "value": {"type":"LOCAL_FOLDER","path":"c:\\dir"}
}
```

# 11. Removing Target Location <a name="remove_target_location"></a>
## Request
```http
PATCH /drafts/{draft id}/policies/{policy id}/settings
content_type: application/json-patch+json
```
```json5
{
    "op": "remove",
    "path": "/target_location"
}
```

# 12. Changing of Options <a name="change_options"></a>
## Request
```http
PATCH /drafts/{draft id}/policies/{policy id}/settings
content_type: application/json-patch+json
```
```json5
{
    "op": "replace",
    "path": "/recovery_options",
    "value": {
        "error_handling": {
            "reattempt_on_error": true,
            "reattempt_time_frame": {
                "type": "SECONDS",
                "value": 30
            },
            "reattempts_count": 30,
            "silent_mode": false
        },
        "event_trace": {
            "enabled": false,
            "global_configuration_used": true,
            "level": "WARNING"
        },
        "full_path_recovery": false,
        "overwrite_mode": "OVERWRITE_EXISTING_FILES",
        "pre_post_commands": {
            "post_commands": {
                "command": "",
                "command_arguments": "",
                "continue_on_command_error": false,
                "wait_command_complete": true,
                "working_directory": ""
            },
            "pre_commands": {
                "command": "",
                "command_arguments": "",
                "continue_on_command_error": false,
                "wait_command_complete": true,
                "working_directory": ""
            },
            "use_default_commands": true,
            "use_post_commands": false,
            "use_pre_commands": false
        },
        "priority": "NORMAL",
        "recover_mount_points_targets": false,
        "set_current_date_time": false,
        "silent_reboot": true,
        "validate_backups_before_operation": false
    }
}
```
