# Example request to app-catalog

POST /api/application_catalog/v2/launch_entities

```json
{
  "app_version": "cti.a.p.app.manifest.v1.0~vendor.app.manifest.v1.0",
  "comment": "No comment",
  "entity": {
    "cti": "cti.a.p.dts.func.v1.0~a.ui.ext_p.cyber_protect.nav_menu.subitem.interface.v1.0~vendor.app.my_subitem.v1.0",
    "final": true,
    "traits": {
      "deterministic_behavior": "PURE",
      "return": {
        "id": "cti.a.ui.item.v1.0~a.ui.nav_menu.subitem.v1.0~a.ui.ext_p.cyber_protect.nav_menu.v1.0~vendor.app.my_subitem.v1.0",
        "meta": {
          "order": 10,
          "ext": {
            "icon": "i-plugin-ab--32",
            "label": "Label",
            "tooltip": "Tooltip"
          }
        },
        "content": {
          "asset": "/pavelk/319dac59-df45-ee07-ea03-6a6dfaae937d.json",
          "type": "JSON"
        }
      }
    }
  }
}
```

# Example RAML:

```yml
#%RAML 1.0 Library

uses:
  interfaces: ../types/interfaces.raml

types:
  CyberProtectNavMenuMySubitemConstructor:
    type: interfaces.CyberProtectNavMenuSubitemInterface
    (cti.cti): cti.a.p.dts.func.v1.0~a.ui.ext_p.cyber_protect.nav_menu.subitem.interface.v1.0~vendor.app.my_subitem.v1.0
    (cti.final): true
    additionalProperties: false
    cti-traits:
      entrypoint: false
      deterministic_behavior: PURE

      return:
        id: cti.a.ui.item.v1.0~a.ui.nav_menu.subitem.v1.0~a.ui.ext_p.cyber_protect.nav_menu.v1.0~vendor.app.my_subitem.v1.0
        meta:
          order: 0,
          ext:
            icon: i-plugin-ab--32
            label: Label
            tooltip: Tooltip
        content:
          asset: /pavelk/319dac59-df45-ee07-ea03-6a6dfaae937d.json
          type: JSON
```

# Example request to graphql-gateway

POST /api/platform-graphql-gateway/v2/

```json
{
  "id": "cti.a.p.dts.func.v1.0~a.ui.ext_p.cyber_protect.nav_menu.root.interface.v1.0~a.ui.root.v1.0",
  "params": {
    "tenant_id": "4304bc63-cadb-4899-a32f-acfb139cb412"
  }
}
```

# Example response from graphql-gateway

```json
{
  "id": "cti.a.ui.item.v1.0~a.ui.nav_menu.root.v1.0~a.ui.ext_p.cyber_protect.nav_menu.v1.0~a.ui.root.v1.0",
  "meta": {
    "children": [
      {
        "id": "cti.a.ui.item.v1.0~a.ui.nav_menu.item.v1.0~a.ui.ext_p.cyber_protect.nav_menu.v1.0~a.ui.monitoring.v1.0",
        "meta": {
          "order": 10,
          "ext": {
            "icon": "i-dashboard-o--32",
            "label": "MONITORING",
            "tooltip": "MONITORING"
          },
          "children": [
            {
              "id": "cti.a.ui.item.v1.0~a.ui.nav_menu.subitem.v1.0~a.ui.ext_p.cyber_protect.nav_menu.v1.0~vendor.app.my_subitem.v1.0",
              "meta": {
                "order": 10,
                "ext": {
                  "label": "My subitem",
                  "tooltip": "My subitem"
                }
              }
            }
          ]
        }
      },
      {
        "id": "cti.a.ui.item.v1.0~a.ui.nav_menu.item.v1.0~a.ui.ext_p.cyber_protect.nav_menu.v1.0~a.ui.management.v1.0",
        "meta": {
          "order": 20,
          "ext": {
            "icon": "i-backup-dr-o--32",
            "label": "MANAGEMENT",
            "tooltip": "MANAGEMENT"
          },
          "children": [
            {
              "id": "cti.a.ui.item.v1.0~a.ui.nav_menu.subitem.v1.0~a.ui.ext_p.cyber_protect.nav_menu.v1.0~vendor.app.my_subitem.v1.0",
              "meta": {
                "order": 10,
                "ext": {
                  "label": "My subitem",
                  "tooltip": "My subitem"
                }
              }
            }
          ]
        }
      },
      {
        "id": "cti.a.ui.item.v1.0~a.ui.nav_menu.item.v1.0~a.ui.ext_p.cyber_protect.nav_menu.v1.0~a.ui.protection.v1.0",
        "meta": {
          "order": 30,
          "ext": {
            "icon": "i-protection-o--32",
            "label": "PROTECTION",
            "tooltip": "PROTECTION"
          },
          "children": [
            {
              "id": "cti.a.ui.item.v1.0~a.ui.nav_menu.subitem.v1.0~a.ui.ext_p.cyber_protect.nav_menu.v1.0~vendor.app.my_subitem.v1.0",
              "meta": {
                "order": 10,
                "ext": {
                  "label": "My subitem",
                  "tooltip": "My subitem"
                }
              }
            }
          ]
        }
      },
      {
        "id": "cti.a.ui.item.v1.0~a.ui.nav_menu.item.v1.0~a.ui.ext_p.cyber_protect.nav_menu.v1.0~a.ui.software_management.v1.0",
        "meta": {
          "order": 40,
          "ext": {
            "icon": "i-software-management-o--32",
            "label": "SOFTWARE MANAGEMENT",
            "tooltip": "SOFTWARE MANAGEMENT"
          },
          "children": [
            {
              "id": "cti.a.ui.item.v1.0~a.ui.nav_menu.subitem.v1.0~a.ui.ext_p.cyber_protect.nav_menu.v1.0~vendor.app.my_subitem.v1.0",
              "meta": {
                "order": 10,
                "ext": {
                  "label": "My subitem",
                  "tooltip": "My subitem"
                }
              }
            }
          ]
        }
      }
    ]
  }
}
```
