# Example request to app-catalog
```json
POST /api/application_catalog/v2/launch_entities
{
  "comment": "No comment",
  "app_version": "cti.a.p.app.manifest.v1.0~vendor.app.manifest.v1.0",
  "entity": {
    "cti": "cti.a.p.dts.func.v1.0~a.ui.ext_p.partner_level_configuration.item.interface.v1.0~vendor.app.tab1.v1.0",
    "final": true,
    "traits": {
      "deterministic_behavior": "PURE",
      "tags": [
        "cti.a.p.dts.tag.v1.0~vendor.app.tab1.v1.0"
      ],
      "return": {
        "id": "cti.a.ui.item.v1.0~a.ui.ext_p.partner_level_configuration.item.v1.0~vendor.app.tab1.v1.0",
        "meta": {
          "order": 0,
          "ext": {
            "label": "Tab title"
          }
        },
        "content": {
          "asset": "/pavelk/319dac59-df45-ee07-ea03-6a6dfaae937d.json",
          "type": "JSON"
        }
      }
    }
  }
}
```

# Example RAML:
```yml
PartnerLevelConfigurationTab1Constructor:
  type: interfaces.PartnerLevelConfigurationItemInterface
  (cti.cti): cti.a.p.dts.func.v1.0~a.ui.ext_p.partner_level_configuration.item.interface.v1.0~vendor.app.tab1.v1.0
  (cti.final): true
  cti-traits:
    deterministic_behavior: PURE
    tags:
      - cti.a.p.dts.tag.v1.0~vendor.app.tab1.v1.0
    return:
      id: cti.a.ui.item.v1.0~a.ui.ext_p.partner_level_configuration.item.v1.0~vendor.app.tab1.v1.0
      meta:
        order: 0
        ext:
          label: Tab title
      content:
        asset: /pavelk/319dac59-df45-ee07-ea03-6a6dfaae937d.json
        type: JSON
```

# Example response from app-manager
```json
GET /api/application_manager/v2/cti/metadata
{
  "items": [{
    "cti": "cti.a.p.dts.func.v1.0~a.ui.ext_p.partner_level_configuration.item.interface.v1.0~vendor.app.tab1.v1.0",
    "kind": "WELLKNOWN",
    "state": "ENABLED",
    "created_at": "2023-06-22T16:03:23Z",
    "updated_at": "2023-06-23T10:03:27Z",
    "final": true,
    "traits": {
      "deterministic_behavior": "PURE",
      "tags": [
        "cti.a.p.dts.tag.v1.0~vendor.app.tab1.v1.0"
      ],
      "return": {
        "id": "cti.a.ui.item.v1.0~a.ui.ext_p.partner_level_configuration.item.v1.0~vendor.app.tab1.v1.0",
        "meta": {
          "order": 0,
          "ext": {
            "label": "Tab title"
          }
        },
        "content": {
          "asset": "/pavelk/319dac59-df45-ee07-ea03-6a6dfaae937d.json",
          "type": "JSON"
        }
      }
    }
  }],
  "paging": {
    // ...
  }
}
```

# Example request to graphql-gateway
```json
POST /api/platform-graphql-gateway/v2/resolve
{
  "id": "cti.a.p.dts.func.v1.0~a.ui.ext_p.partner_level_configuration.root.v1.0",
  "params": {
    "tenant_id": "4304bc63-cadb-4899-a32f-acfb139cb412",
    "tags": [
      "cti.a.p.dts.tag.v1.0~vendor.app.tab1.v1.0"
    ]
  }
}
```

# Example response from graphql-gateway
```json
{
  "id": "cti.a.ui.item.v1.0~a.ui.ext_p.partner_level_configuration.root.v1.0~a.ui.root.v1.0",
  "meta": {
    "children": [
      {
        "id": "cti.a.ui.item.v1.0~a.ui.ext_p.partner_level_configuration.item.v1.0~vendor.app.tab1.v1.0",
        "meta": {
          "order": 0,
          "ext": {
            "label": "Tab title"
          }
        },
        "content": {
          "asset": "/pavelk/319dac59-df45-ee07-ea03-6a6dfaae937d.json",
          "type": "JSON"
        }
      }
    ]
  }
}
```