# Example request to app-catalog

```json
POST /api/application_catalog/v2/launch_entities
{
  "comment": "No comment",
  "app_version": "cti.a.p.app.manifest.v1.0~vendor.app.manifest.v1.0",
  "entity": {
    "cti": "cti.a.p.dts.func.v1.0~a.ui.ext_p.workload_actions.action.v1.0~vendor1.app1.action1.v1.0",
    "final": true,
    "traits": {
      "deterministic_behavior": "PURE",
      "return": {
        "id": "cti.a.ui.item.v1.0~a.ui.ext_p.workload_actions.action.v1.0~vendor1.app1.action1.v1.0",
        "meta": {
          "order": 0,
          "ext": {
            "workload_types": "$.tags",
            "name": "Vendor App name",
            "label": "Action name",
            "type": "APP"
          }
        },
        "content": {
          "type": "JSON",
          "asset": "/vendor/319dac59-df45-ee07-ea03-6a6dfaae937d.json",
        }
      },
      "tags": [
        "cti.a.p.wm.workload.v1.0~a.p.aspect.v1.0~vendor1.app1.machine.v1.0",
        "cti.a.p.wm.workload.v1.0~a.p.aspect.v1.0~vendor1.app1.vmwesx.v1.0"
      ]
    }
  }
}
```

# Example RAML:
```yml
VendorWorkloadActionsAction1:
  type: interfaces.UIeWorkloadActionsActionInterface
  (cti.cti): cti.a.p.dts.func.v1.0~a.ui.ext_p.workload_actions.action.v1.0~vendor.app.action1.v1.0
  (cti.final): true

  cti-traits:
    deterministic_behavior: PURE

    return:
      id: cti.a.ui.item.v1.0~a.ui.ext_p.workload_actions.action.v1.0~vendor1.app1.action1.v1.0
      meta:
        order: 0
        ext:
          workload_types: $.tags
          name: Vendor App name
          label: Action name
          type: APP
      content:
        type: JSON
        asset: /vendor/319dac59-df45-ee07-ea03-6a6dfaae937d.json

    tags:
      - cti.a.p.wm.workload.v1.0~a.p.aspect.v1.0~vendor1.app1.machine.v1.0
      - cti.a.p.wm.workload.v1.0~a.p.aspect.v1.0~vendor1.app1.vmwesx.v1.0
```

# Example request to graphql-gateway
```json
POST /api/platform-graphql-gateway/v2/resolve
{
  "id": "cti.a.p.dts.func.v1.0~a.ui.ext_p.workload_actions.root.v1.0",
  "params": {
    "workloads_types": [
      "cti.a.p.wm.workload.v1.0~a.p.aspect.v1.0~vendor1.app1.machine.v1.0"
    ]
  }
}
```

# Example response from graphql-gateway
```json
{
  "id": "cti.a.ui.item.v1.0~a.ui.ext_p.workload_actions.actions.v1.0~a.ui.root.v1.0",
  "meta": {
    "children": [
      {
        "id": "cti.a.ui.item.v1.0~a.ui.ext_p.workload_actions.action.v1.0~vendor1.app1.action1.v1.0",
        "meta": {
          "order": 0,
          "ext": {
            "workload_types": [
              "cti.a.p.wm.workload.v1.0~a.p.aspect.v1.0~vendor1.app1.machine.v1.0",
              "cti.a.p.wm.workload.v1.0~a.p.aspect.v1.0~vendor1.app1.vmwesx.v1.0"
            ],
            "name": "Vendor App name",
            "label": "Action name",
            "type": "APP"
          }
        },
        "content": {
          "type": "JSON",
          "asset": "/vendor/319dac59-df45-ee07-ea03-6a6dfaae937d.json"
        }
      }
    ]
  }
}
```
