# Vendor's Workload type (already provisioned)

```yml
uses:
  wm: ../../../../wm/types.raml

VendorWorkloadTypeWorkload1:
  type: wm.Aspect
  (cti.cti): cti.a.p.wm.workload.v1.0~a.p.wm.aspect.v1.0~vendor1.app1.workload_type1.v1.0
  (cti.final): true

  cti-traits:
    # ...

  properties:
    attributes:
      properties:
        name:
          type: string
          description: Hostname
        mac_address:
          type: string
          description: MAC address
        score: integer
        array_example:
          type: array
          items:
            type: integer
```

# Example request to app-catalog

```json
// POST /api/application_catalog/v2/launch_entities
{
  "comment": "No comment",
  "app_version": "cti.a.p.app.manifest.v1.0~vendor1.app1.manifest.v1.0",
  "entity": {
    "cti": "cti.a.p.dts.func.v1.0~a.ui.ext_p.workload_actions.action.v1.0~vendor1.app1.action1.v1.0",
    "final": true,
    "traits": {
      "deterministic_behavior": "PURE",
      "return": {
        "id": "cti.a.ui.item.v1.0~a.ui.ext_p.workload_actions.action.v1.0~vendor1.app1.action1.v1.0",
        "meta": {
          "order": 0,
          "ext": {
            "workload_types": "$.tags",
            "name": "Vendor App name",
            "label": "Action name",
            "type": "URL",
            "url": "https://service.vendor.com/workloads/configure?mac={{ $$.attributes.mac_address }}"
          }
        }
      },
      "tags": [
        "cti.a.p.wm.workload.v1.0~a.p.wm.aspect.v1.0~vendor1.app1.workload_type1.v1.0"
      ]
    }
  }
}
```

# Example RAML:
```yml
VendorWorkloadActionsAction1:
  type: interfaces.UIeWorkloadActionsActionInterface
  (cti.cti): cti.a.p.dts.func.v1.0~a.ui.ext_p.workload_actions.action.v1.0~vendor1.app1.action1.v1.0
  (cti.final): true

  cti-traits:
    deterministic_behavior: PURE

    return:
      id: cti.a.ui.item.v1.0~a.ui.ext_p.workload_actions.action.v1.0~vendor1.app1.action1.v1.0
      meta:
        order: 0
        ext:
          workload_types: $.tags
          name: Vendor App name
          label: Action name
          type: URL
          url: https://service.vendor.com/workloads/configure?mac={{ $$.attributes.mac_address }}

    tags:
      - cti.a.p.wm.workload.v1.0~a.p.wm.aspect.v1.0~vendor1.app1.workload_type1.v1.0
```

# Example request to graphql-gateway
```json
// POST /api/platform-graphql-gateway/v2/resolve
{
  "id": "cti.a.p.dts.func.v1.0~a.ui.ext_p.workload_actions.root.v1.0",
  "params": {
    "workloads_types": [
      "cti.a.p.wm.workload.v1.0~a.p.wm.aspect.v1.0~vendor1.app1.workload_type1.v1.0"
    ]
  }
}
```

# Example response from graphql-gateway
```json
{
  "id": "cti.a.ui.item.v1.0~a.ui.ext_p.workload_actions.actions.v1.0~a.ui.root.v1.0",
  "meta": {
    "children": [
      {
        "id": "cti.a.ui.item.v1.0~a.ui.ext_p.workload_actions.action.v1.0~vendor1.app1.action1.v1.0",
        "meta": {
          "order": 0,
          "ext": {
            "workload_types": [
              "cti.a.p.wm.workload.v1.0~a.p.wm.aspect.v1.0~vendor1.app1.workload_type1.v1.0"
            ],
            "name": "Vendor App name",
            "label": "Action name",
            "type": "URL",
            "url": "https://service.vendor.com/workloads/configure?mac={{ $.attributes.mac_address }}"
          }
        }
      }
    ]
  }
}
```

