# Example request to app-catalog

```json
POST /api/application_catalog/v2/launch_entities
{
  "comment": "No comment",
  "app_version": "cti.a.p.app.manifest.v1.0~vendor1.app1.manifest.v1.0",
  "entity": {
    "cti": "cti.a.p.dts.func.v1.0~a.ui.ext_p.workloads_grid.column.interface.v1.0~vendor1.app1.column1.v1.0",
    "final": true,
    "traits": {
      "deterministic_behavior": "PURE",
      "return": {
        "id": "cti.a.ui.item.v1.0~a.ui.ext_p.workloads_grid.column.v1.0~vendor1.app1.column1.v1.0",
        "meta": {
          "order": 0,
          "ext": {
            "workload_types": "$.tags",
            "name": "Vendor App name",
            "label": "Column name",
            "data_path": "$$.path.to.value",
            "format": "TEXT",
            "sortable": true
          }
        }
      },
      "tags": [
        "cti.a.p.wm.workload.v1.0~a.p.aspect.v1.0~vendor1.app1.machine.v1.0"
      ]
    }
  }
}
```

# Example RAML

```yml
VendorWorkloadsGridColumnColumn1:
  type: interfaces.UIeWorkloadsGridColumnUIItem
  (cti.cti): cti.a.p.dts.func.v1.0~a.ui.ext_p.workloads_grid.column.interface.v1.0~vendor1.app1.column1.v1.0
  (cti.final): true

  cti-traits:
    deterministic_behavior: PURE

    return:
      id: cti.a.ui.item.v1.0~a.ui.ext_p.workloads_grid.column.v1.0~vendor1.app1.column1.v1.0
      meta:
        order: 0
        ext:
          workload_types: $.tags
          name: Vendor App name
          label: Column name
          data_path: $$.path.to.value
          format: TEXT
          sortable: true

    tags:
      - cti.a.p.wm.workload.v1.0~a.p.aspect.v1.0~vendor1.app1.machine.v1.0
```

# Example request to graphql-gateway

```json
POST /api/platform-graphql-gateway/v2/resolve
{
  "id": "cti.a.p.dts.func.v1.0~a.ui.ext_p.workloads_grid.columns.v1.0",
  "params": {
    "workload_types": [
      "cti.a.p.wm.workload.v1.0~a.p.aspect.v1.0~vendor1.app1.machine.v1.0"
    ]
  }
}
```

# Example response from graphql-gateway

```json
{
  "id": "cti.a.ui.item.v1.0~a.ui.ext_p.workloads_grid.columns.v1.0~a.ui.root.v1.0",
  "meta": {
    "children": [
      {
        "id": "cti.a.ui.item.v1.0~a.ui.ext_p.workloads_grid.column.v1.0~vendor1.app1.column1.v1.0",
        "meta": {
          "order": 0,
          "ext": {
            "workload_types": [
              "cti.a.p.wm.workload.v1.0~a.p.aspect.v1.0~vendor1.app1.machine.v1.0"
            ],
            "name": "Vendor App name",
            "label": "Column name",
            "data_path": "$.path.to.value",
            "format": "TEXT",
            "sortable": true
          }
        }
      }
    ]
  }
}
```
