# Context

1. The vendor (let it be Sophos) is already created an application with its own column (CTI: `cti.a.ui.item.v1.0~a.ui.ext_p.workloads_grid.column.v1.0~vendor1.app1.column1.v1.0`)
   See [1-mocks-vendor-column.md](1-mocks-vendor-column.md)

2. Acronis created its own set of general columns for Workload Grid and described it as RAML types in `acronis-platform` repository

3. Also, we have a second vendor (ACME Corp.) that created its own set of columns for the Workload Grid (for example CTI is `(CTI: cti.a.ui.item.v1.0~a.ui.ext_p.workloads_grid.column.v1.0~vendor2.app2.column2.v1.0`)


# Goal

The goal is to fetch Workload Grid columns provided by Acronis and the first vendor (Sophos)


# Example request to graphql-gateway

```json
POST /api/platform-graphql-gateway/v2/resolve
{
  "id": "cti.a.p.dts.func.v1.0~a.ui.ext_p.workloads_grid.columns.v1.0",
  "params": {
    "workload_types": [
      "cti.a.p.wm.workload.v1.0~a.p.aspect.v1.0",
      "cti.a.p.wm.workload.v1.0~a.p.aspect.v1.0~vendor1.app1.machine1.v1.0"
    ]
  }
}
```

Notes:
1. Acronis uses CTI `cti.a.p.wm.workload.v1.0~a.p.aspect.v1.0` in its own columns, and adding this CTI to each request will return the column set that is applicable to any workload either Acronis workload, or a vendor workload
2. CTI `cti.a.p.wm.workload.v1.0~a.p.aspect.v1.0~vendor1.app1.machine1.v1.0` points that we want fetch all vendor columns that are applicable to that vendor's workload, which can be vendor columns, columns defined by Acronis, or column from any other vendor


# Example response from graphql-gateway

```json
{
  "id": "cti.a.ui.item.v1.0~a.ui.ext_p.workloads_grid.columns.v1.0",
  "meta": {
    "children": [
      {
        "id": "cti.a.ui.item.v1.0~a.ui.ext_p.workloads_grid.column.v1.0~vendor1.app1.column1.v1.0",
        "meta": {
          "order": 0,
          "ext": {
            "workload_types": [
              "cti.a.p.wm.workload.v1.0~a.p.aspect.v1.0~vendor1.app1.machine1.v1.0"
            ],
            "name": "Vendor App name",
            "label": "Column name",
            "data_path": "$$.path.to.value",
            "format": "TEXT",
            "sortable": true
          }
        }
      },
      {
        "id": "cti.a.ui.item.v1.0~a.ui.ext_p.workloads_grid.column.v1.0~a.ui.name.v1.0",
        "meta": {
          "order": 2,
          "ext": {
            "workload_types": [
              "cti.a.p.wm.workload.v1.0~a.p.wm.aspect.v1.0"
            ],
            "name": "General",
            "label": "Name",
            "data_path": "$$.displayName",
            "format": "TEXT",
            "sortable": true
          }
        }
      },
      {
        "id": "cti.a.ui.item.v1.0~a.ui.ext_p.workloads_grid.column.v1.0~a.ui.account.v1.0",
        "meta": {
          "order": 3,
          "ext": {
            "workload_types": [
              "cti.a.p.wm.workload.v1.0~a.p.wm.aspect.v1.0"
            ],
            "name": "General",
            "label": "Account",
            "data_path": "$$.agent.tenant.name",
            "format": "TEXT",
            "sortable": true
          }
        }
      }
    ]
  }
}
```
