# Example request to app-catalog

```json
POST /api/application_catalog/v2/launch_entities
{
  "comment": "No comment",
  "app_version": "cti.a.p.app.manifest.v1.0~vendor1.app1.manifest.v1.0",
  "entity": {
    "cti": "cti.a.p.wm.workload.v1.0~a.p.wm.aspect.v1.0~vendor1.app1.workload_type1.v1.0",
    "final": true,
    "traits": {
      "name": "Vendor Workload type name",
      "type_alias": "resource.machine",
      "parent_child_relationship_query": [
        {
          "parent_type": "cti.a.p.wm.workload.v1.0~a.p.wm.group.v1.0~a.p.computers.v1.0"
        }
      ],
      "aggregates_detection_query": {
        "aggregate_candidate_rules": [
          {
            "aggregate_type": "cti.a.p.wm.workload.v1.0~a.p.wm.aggregate.v1.0~a.p.machine.v1.0",
            "attribute_key_bindings": {
              "cti.a.p.wm.aggregates_detection_query.attribute_condition_key.v1.0~a.p.host_name.v1.0": "$$.name",
              "cti.a.p.wm.aggregates_detection_query.attribute_condition_key.v1.0~a.p.mac_address.v1.0": "$$.mac_address"
            }
          }
        ]
      },
      "indexable_attributes": [
        "$$.name",
        "$$.mac_address"
      ]
    },
    "schema": {
      "$schema": "http://json-schema.org/draft-07/schema#",
      "$ref": "#/definitions/Vendor1.App1.Code",
      "definitions": {
        "Vendor1.App1.Code": {
          "additionalProperties": false,
          "properties": {
            "attributes": {
              "type": "object",
              "properties": {
                "name": {
                  "type": "string",
                  "description": "Hostname"
                },
                "mac_address": {
                  "type": "string",
                  "description": "MAC address"
                },
                "score": {
                  "type": "integer"
                },
                "array_example": {
                  "type": "array",
                  "items": {
                    "type": "integer"
                  }
                }
              }
            }
          }
        }
      }
    }
  }
}
```

# Example RAML

```yml
uses:
  wm: ../../../../wm/types.raml

VendorWorkloadTypeWorkload1:
  type: wm.Aspect
  (cti.cti): cti.a.p.wm.workload.v1.0~a.p.wm.aspect.v1.0~vendor1.app1.workload_type1.v1.0
  (cti.final): true

  cti-traits:
    name: Vendor Workload type name
    type_alias: resource.machine
    parent_child_relationship_query:
      - parent_type: cti.a.p.wm.workload.v1.0~a.p.wm.group.v1.0~a.p.computers.v1.0
    aggregates_detection_query:
      aggregate_candidate_rules:
        - aggregate_type: cti.a.p.wm.workload.v1.0~a.p.wm.aggregate.v1.0~a.p.machine.v1.0
          attribute_key_bindings:
            cti.a.p.wm.aggregates_detection_query.attribute_condition_key.v1.0~a.p.host_name.v1.0: $$.name           # Hostname
            cti.a.p.wm.aggregates_detection_query.attribute_condition_key.v1.0~a.p.mac_address.v1.0: $$.mac_address  # MAC address
    indexable_attributes:
      - $$.name
      - $$.mac_address

  properties:
    attributes:
      properties:
        name:
          type: string
          description: Hostname
        mac_address:
          type: string
          description: MAC address
        score: integer
        array_example:
          type: array
          items:
            type: integer
```

### Example of creating the new instance of Workload

```json5
// POST https://mc-st2308b3.do.acronis.fun/api/workload_management/v5/workloads
[{
    "type_alias": "resource.machine",
    "type": "cti.a.p.wm.workload.v1.0~a.p.wm.aspect.v1.0~a.p.machine.v1.0",  // it's Acronis' workload
    "name": "MM-Win10-1-manual",
    "user_defined_name": "MM-Win10-1-manual",
    "agent_id": "eeefc467-8fbf-496f-a26e-bc6a5163de78",  // won't be provided by vendors in ph1
    "attributes": {
        "agent": {
            "components": [
                "x64WindowsAgent"
            ],
        },
        "default": {
            "name": "MM-Win10-1-ORIG",
            "vendor_test_data": "Test default value",
            "vendor(_)test_data2": "Test default value"
        }
    }
}]
```
