
# CTI thoughts

cti.a.p.em.event.v1.0~a.p.audit.v1.0~a.scripting.audit.script.created.v1.1
cti.a.p.em.event_type.v1.0~a.scripting.audit.script.created.v1.1

type - `cti.a.p.em.event_type.v1.0~a.scripting.audit.script.created.v1.0`

## Cti query

cti.a.p.em.event.v1.0~a.p.audit.v1.0
-> ID(cti.a.p.em.event_type.v1.0~a.scripting.audit.script.created.v1.0)

cti.a.p.em.event.v1.0~a.p.audit.v1.0 -> cti.a.p.em.event.v1.0[ type="cti.a.p.em.event_type.v1.0" ]

``` yaml
Event:
  id: uuid
  type: cti.a.p.em.event.v1.0~....
```

GET /events?cti=cti.a.p.em.event.v1.0~a.p.audit.v1.0

``` yaml
EventType:
  id: cti.a.p.em.event.v1.0~....
  topic_id: cti.a.p.em.topic.v1.0~....
```

GET /events_type?cti=`cti.a.p.em.event.v1.0~a.p.audit.v1.0`

``` yaml
EventTopic:
  id: cti.a.p.em.topic.v1.0~....
```

GET /topics?id=`cti.a.p.em.topic.v1.0`

cti.<CTX_1>~<CTX_2>~<CTX_n>

subset of objects (or single instance) with base type CTX_1~CTX_(n-1)

`cti.a.p.em.topic.v1.0~a.p.audit.v1.0`

```yaml
Topic:
  id: cti.a.p.em.topic.v1.0~a.p.audit.v1.0
  x:
  y:
  z:
```

## GET /`topics`?id=`cti.a.p.em.topic.v1.0~a.p.audit.v1.0~a.b.c.v2.0`

rp: cti.a.p.em.topic.v1.0[ id=`cti.a.p.em.topic.v1.0~a.p.audit.v1.0` ]
rp: cti.a.p.em.topic.v1.0~a.p.audit.v1.0

short notation for `em.topic` == `id=<xxx>`

## GET /`events`?type=`cti.a.p.em.event.v1.0~a.p.audit.v1.0`&topic=`cti.a.p.em.topic.v1.0~a.p.audit.v1.0`

rp: cti.a.p.em.event.v1.0[ type=`cti.a.p.em.event.v1.0~a.p.audit.v1.0` & topic=`cti.a.p.em.topic.v1.0~a.p.audit.v1.0` ]
rp: cti.a.p.em.event.v1.0~a.p.audit.v1.0[ topic=`cti.a.p.em.topic.v1.0~a.p.audit.v1.0` ]

short notation for em.event == type=`<xxx>`

## GET /`events`?topic=`cti.a.p.em.topic.v1.0~a.p.audit.v1.0`

rp: cti.a.p.em.event.v1.0[ topic=`cti.a.p.em.topic.v1.0~a.p.audit.v1.0` ]

## GET /`event_types`?id=`cti.a.p.em.event.v1.0~a.p.audit.v1.0`

rp: cti.a.p.em.event_type.v1.0[ id=`cti.a.p.em.event.v1.0~a.p.audit.v1.0` ]

NO short notation for em.event_type
ё## GET /`events`?type=`cti.a.p.em.event.v1.0~a.p.audit.v1.0~a.p.script.created.v1.0`

rp: cti.a.p.em.event.v1.0[ type=`cti.a.p.em.event.v1.0~a.p.audit.v1.0~a.p.script.created.v1.0` ]
rp: cti.a.p.em.event.v1.0~a.p.audit.v1.0~a.p.script.created.v1.0

short notation for em.event == type=`<xxx>`

## GET /`event_types`?id=`cti.a.p.em.event.v1.0~a.p.audit.v1.0~a.p.script.created.v1.0`

rp: cti.a.p.em.event_type.v1.0[ id=`cti.a.p.em.event.v1.0~a.p.audit.v1.0~a.p.script.created.v1.0` ]

Could be short notation
rp: cti.a.p.em.event_type.v1.0~a.p.audit.v1.0~a.p.script.created.v1.0

## GET /`events`?cti=`cti.a.p.em.event.v1.0~a.p.audit.v1.0~a.scripting.script.created.v1.0`

## GET /`events`?type=`cti.a.p.em.event_type.v1.0~a.p.audit.v1.0~a.scripting.v1.0.script.created`&topic=`cti.a.p.em.topic.v1.0~a.p.audit.v1.0`

rp: cti.a.p.em.event.v1.0[ type=`cti.a.p.em.event.v1.0~a.p.audit.v1.0` & topic=`cti.a.p.em.topic.v1.0~a.p.audit.v1.0` ]
rp: cti.a.p.em.event.v1.0~a.p.audit.v1.0[ topic=`cti.a.p.em.topic.v1.0~a.p.audit.v1.0` ]

short notation for `cti.a.p.em.event.v1.0~<XXX>` == `cti.a.p.em.event.v1.0[ type=cti.a.p.em.event.v1.0~<XXX> ]`

## Other considerations

Alert -> XAlert (type) -> Application Y with instance of XAlert

## How RAML description became schema with trait in

```yaml
  ApplicationPayload:
    type: object
    properties:
      name: string
      type: string
  #
  ApplicationTurnedOnEvent:
    type: base.Event
    (cti.cti): cti.a.p.em.event.v1.0~a.p.applications.turned_on.v1.0
    #
    cti-traits:
      topic_id: cti.a.p.em.topic.v1.0~a.p.licensing.v1.0
      description: TODO
      datacontenttype: application/json
      hasdata: true
    #
    properties:
      data: ApplicationPayload
```

1. `cti-traits` declared as instance of `cti.a.p.em.event_type.v1.0` that defines required API endpoint: `POST /event_type`.
1. `cti-traits` part goes as-is into POST body.
1. `cti-traits` implies that new class discriminator (see declaration of EventType) should be equal to `(cti.cti)` of parent type, i.e. `id` == `cti.a.p.em.event.v1.0~a.p.tenant.enabled.v1.0`.
1. `schema` field of `EventType` annotated with `dataSchema` keyword that means that it should contain schema of `ApplicationTurnedOnEvent` RAML type in Json Schema format.

`POST` /event_type

```yaml
  id: cti.a.p.em.event_type.v1.0~a.p.tenant.enabled.v1.0
  topic_id: cti.a.p.em.topic.v1.0~a.p.tenant.v1.0
  description: Event is raised when tenant is enabled
  datacontenttype: application/json
  hasdata: true
  dataschema:
    id: cti.a.p.em.event.v1.0~a.p.tenant.enabled.v1.0
    payload:
      {
        "$schema": "http://json-schema.org/draft-07/schema#",
        "properties": {
          "data": {
            "type": "object",
            "additionalProperties": false,
            "required": [ "created_at", "deleted_at" ],
            "properties": {
              "created_at": { "type": "string", "format": "date-time" },
              "deleted_at": { "type": "string", "format": "date-time" }
            }
          }
        }
      }
```

## Use-cases

  * `urn:::cti.a.p.em.event.v1.0[ fu="bar" ]:rw`
  * `urn:::cti.a.p.em.event.v1.0~a.p.offering_item.off.v1.0:rw`
  * `urn:::cti.a.p.em.event.v1.0[ type="cti.a.p.em.event_type.v1.0~a.p.offering_item.off.v1.0" ]:rw`
  * `urn:::cti.a.p.em.event.v1.0[ topic="cti.a.p.em.topic.v1.0~a.p.tenant.v1.0" ]:rw`
  * `urn:::cti.a.p.em.event.v1.0[ type="cti.a.p.em.event_type.v1.0~a.p.*", topic="cti.a.p.em.topic.v1.0~a.p.tenant.v1.0" ]:rw`
  * `urn:::cti.a.p.em.event.v1.0~a.p.*[ topic="cti.a.p.em.topic.v1.0~a.p.tenant.v1.0" ]:rw`
  * `/events?type=cti.a.p.em.event_type.v1.0~a.p.offering_item.off.v1.0&topic=cti.a.p.em.topic.v1.0~a.p.tenant.v1.0`
