import os


def convert_to_snake(s: str) -> str:
    result = ''
    before = None
    for c in s:
        if before is None:
            before = c
            result += c.lower()
            continue
        if c.isupper() and before.islower():
            result += "_"
        result += c.lower()
        before = c
    return result


for filename in os.scandir("."):
    name, ext = os.path.splitext(filename.name)
    if ext == ".raml":
        print(filename.name)
        with open(filename, 'r') as f:
            str_data = f.read()
        with open(filename.name + '.diff', 'w') as f:
            f.write(convert_to_snake(str_data))
